/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen;

import com.badlogic.gdx.jnigen.AntPathMatcher;
import com.badlogic.gdx.jnigen.BuildConfig;
import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.FileDescriptor;
import java.util.ArrayList;

public class AndroidNdkScriptGenerator {
    public void generate(BuildConfig config, BuildTarget target) {
        String include;
        if (target.os != BuildTarget.TargetOs.Android) {
            throw new IllegalArgumentException("target os must be Android");
        }
        if (!config.libsDir.exists() && !config.libsDir.mkdirs()) {
            throw new RuntimeException("Couldn't create directory for shared library files in '" + config.libsDir + "'");
        }
        if (!config.jniDir.exists() && !config.jniDir.mkdirs()) {
            throw new RuntimeException("Couldn't create native code directory '" + config.jniDir + "'");
        }
        ArrayList<FileDescriptor> files = new ArrayList<FileDescriptor>();
        int idx = 0;
        String[] includes = new String[target.cIncludes.length + target.cppIncludes.length];
        String[] stringArray = target.cIncludes;
        int n = target.cIncludes.length;
        int n2 = 0;
        while (n2 < n) {
            include = stringArray[n2];
            includes[idx++] = config.jniDir + "/" + include;
            ++n2;
        }
        stringArray = target.cppIncludes;
        n = target.cppIncludes.length;
        n2 = 0;
        while (n2 < n) {
            include = stringArray[n2];
            includes[idx++] = config.jniDir + "/" + include;
            ++n2;
        }
        idx = 0;
        String[] excludes = new String[target.cExcludes.length + target.cppExcludes.length + 1];
        String[] stringArray2 = target.cExcludes;
        int n3 = target.cExcludes.length;
        n = 0;
        while (n < n3) {
            String exclude = stringArray2[n];
            excludes[idx++] = config.jniDir + "/" + exclude;
            ++n;
        }
        stringArray2 = target.cppExcludes;
        n3 = target.cppExcludes.length;
        n = 0;
        while (n < n3) {
            String exclude = stringArray2[n];
            excludes[idx++] = config.jniDir + "/" + exclude;
            ++n;
        }
        excludes[idx] = "**/target/*";
        this.gatherSourceFiles(config.jniDir, includes, excludes, files);
        FileDescriptor application = config.jniDir.child("Application.mk");
        application.writeString(new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/Application.mk.template", FileDescriptor.FileType.Classpath).readString(), false);
        String template = new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/Android.mk.template", FileDescriptor.FileType.Classpath).readString();
        StringBuilder srcFiles = new StringBuilder();
        int i = 0;
        while (i < files.size()) {
            if (i > 0) {
                srcFiles.append("\t");
            }
            srcFiles.append(files.get(i).path().replace('\\', '/').replace(String.valueOf(config.jniDir.toString()) + "/", ""));
            if (i < files.size() - 1) {
                srcFiles.append("\\\n");
            } else {
                srcFiles.append("\n");
            }
            ++i;
        }
        StringBuilder headerDirs = new StringBuilder();
        String[] stringArray3 = target.headerDirs;
        int n4 = target.headerDirs.length;
        int n5 = 0;
        while (n5 < n4) {
            String headerDir = stringArray3[n5];
            headerDirs.append(headerDir);
            headerDirs.append(" ");
            ++n5;
        }
        template = template.replace("%sharedLibName%", config.sharedLibName);
        template = template.replace("%headerDirs%", headerDirs);
        template = template.replace("%cFlags%", target.cFlags);
        template = template.replace("%cppFlags%", target.cppFlags);
        template = template.replace("%linkerFlags%", target.linkerFlags);
        template = template.replace("%srcFiles%", srcFiles);
        config.jniDir.child("Android.mk").writeString(template, false);
    }

    private void gatherSourceFiles(FileDescriptor file, String[] includes, String[] excludes, ArrayList<FileDescriptor> files) {
        String fileName = file.path().replace('\\', '/');
        if (file.isDirectory()) {
            if (this.match(fileName, excludes)) {
                return;
            }
            FileDescriptor[] fileDescriptorArray = file.list();
            int n = fileDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileDescriptor child = fileDescriptorArray[n2];
                this.gatherSourceFiles(child, includes, excludes, files);
                ++n2;
            }
        } else if (this.match(fileName, includes) && !this.match(fileName, excludes)) {
            files.add(file);
        }
    }

    private boolean match(String file, String[] patterns) {
        return new AntPathMatcher().match(file, patterns);
    }
}

