/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.network;

import com.badlogic.gdx.Gdx;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.PlayerRow;
import com.esotericsoftware.gloomhavenhelper.model.AttackModifier;
import com.esotericsoftware.gloomhavenhelper.model.CharacterClass;
import com.esotericsoftware.gloomhavenhelper.network.Message;
import com.esotericsoftware.gloomhavenhelper.network.Network;
import com.esotericsoftware.gloomhavenhelper.util.Input;
import com.esotericsoftware.gloomhavenhelper.util.Serialization;
import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.tcpserver.BroadcastServer;
import com.esotericsoftware.tcpserver.Connection;
import com.esotericsoftware.tcpserver.TcpServer;

class GameServer
extends TcpServer {
    public GameServer() {
        super("server", "Server");
        this.setDaemon(true);
        this.setRetryDelays(1000, 3000, 5000);
    }

    @Override
    protected void retry() {
        this.setPort(App.config.serverPort);
        App.sleep(1000);
        this.setPort(App.config.serverPort);
        super.retry();
    }

    @Override
    public void connected(final Connection connection) {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                App.toast("Client connected.");
            }
        });
        connection.send(String.valueOf(Message.version.value) + " " + App.majorMinor);
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                GameServer.this.sendState(connection, null, 0);
            }
        });
    }

    void sendState(Connection connection, byte[] animate, int offset) {
        Serialization.output.clear();
        Serialization.output.writeInt(App.state.changeNumber);
        Serialization.write(Serialization.output, App.state);
        byte[] bytes = Network.combine(Serialization.output, animate, offset);
        connection.send(Message.gameState.value, bytes, 0, bytes.length);
    }

    @Override
    public void disconnected(Connection connection) {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                App.toast("Client disconnected.");
            }
        });
    }

    @Override
    public void receive(final Connection connection, String event, String payload, byte[] bytes, int count) {
        if (event.equals(Message.undo.value)) {
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    App.gloom.mainMenu.undoItem.setProgrammaticChangeEvents(true);
                    App.gloom.mainMenu.undoItem.toggle();
                    App.gloom.mainMenu.undoItem.setProgrammaticChangeEvents(false);
                }
            });
            return;
        }
        if (event.equals(Message.redo.value)) {
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    App.gloom.mainMenu.redoItem.setProgrammaticChangeEvents(true);
                    App.gloom.mainMenu.redoItem.toggle();
                    App.gloom.mainMenu.redoItem.setProgrammaticChangeEvents(false);
                }
            });
            return;
        }
        if (event.equals(Message.init.value)) {
            try {
                Input input = new Input(bytes);
                final CharacterClass characterClass = CharacterClass.valueOf(input.readString());
                final int init = input.readInt(true);
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        for (PlayerRow row : App.gloom.playerRows) {
                            if (row.player.characterClass != characterClass) continue;
                            row.player.init(init);
                            App.state.changed();
                            break;
                        }
                    }
                });
            }
            catch (Exception ex) {
                connection.close();
                throw new RuntimeException("Error parsing initiative data from client.", ex);
            }
            return;
        }
        if (!event.equals(Message.gameState.value)) {
            connection.close();
            throw new RuntimeException("Invalid event: " + event);
        }
        final byte[] copy = new byte[count];
        System.arraycopy(bytes, 0, copy, 0, count);
        final int changeNumber = Input.readInt(bytes, 0);
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                if (App.state.changeNumber + 1 != changeNumber) {
                    if (Log.WARN) {
                        Log.warn("server", "Rejected change: " + changeNumber + ", required: " + (App.state.changeNumber + 1));
                    }
                    byte[] animate = null;
                    AttackModifier attackModifier1 = App.state.attackModifier1();
                    if (attackModifier1 != null) {
                        AttackModifier attackModifier2 = App.state.attackModifier2();
                        animate = new byte[]{98, (byte)(attackModifier1.ordinal() + 1), (byte)(attackModifier2 == null ? 0 : attackModifier2.ordinal() + 1)};
                    }
                    Network.send(Message.rejected, null, 0, 0);
                    GameServer.this.sendState(connection, animate, 0);
                    return;
                }
                try {
                    Network.loadState(copy);
                }
                catch (Exception ex) {
                    connection.close();
                    throw new RuntimeException("Error parsing game state data from client.", ex);
                }
                for (Connection other : GameServer.this.getConnections()) {
                    if (other == connection) continue;
                    other.send(Message.gameState.value, copy, 0, copy.length);
                }
            }
        });
    }

    public void update() {
        if (App.gloom.intro == null || App.gloom.intro.introPhase != -1) {
            return;
        }
        if (this.isRunning() && this.getPort() != App.config.serverPort) {
            this.setPort(App.config.serverPort);
            App.game.thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BroadcastServer broadcastServer = Network.broadcastServer;
                    synchronized (broadcastServer) {
                        Network.broadcastServer.stop();
                        GameServer.this.stop();
                        App.sleep(100);
                    }
                    Gdx.graphics.requestRendering();
                    GameServer.this.update();
                }
            });
            return;
        }
        if (App.config.server) {
            if (!this.isRunning()) {
                App.game.thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        BroadcastServer broadcastServer = Network.broadcastServer;
                        synchronized (broadcastServer) {
                            App.sleep(100);
                            if (!GameServer.this.isRunning()) {
                                GameServer.this.start();
                            }
                            if (!Network.broadcastServer.isRunning()) {
                                Network.broadcastServer.start();
                            }
                        }
                        Gdx.graphics.requestRendering();
                    }
                });
            }
        } else if (this.isRunning() || Network.broadcastServer.isRunning()) {
            App.game.thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BroadcastServer broadcastServer = Network.broadcastServer;
                    synchronized (broadcastServer) {
                        Network.broadcastServer.stop();
                        if (GameServer.this.stop()) {
                            Gdx.graphics.requestRendering();
                        }
                        App.sleep(100);
                    }
                }
            });
        }
    }
}

