/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util.builders;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.esotericsoftware.gloomhavenhelper.App;

public class ButtonBuilder<B extends ButtonBuilder<B, T>, T extends Button> {
    private Drawable up;
    private Drawable down;
    private Drawable over;
    private Drawable checked;
    private Drawable checkedOver;
    private Drawable disabled;
    private float pressedOffsetX;
    private float pressedOffsetY;
    private float unpressedOffsetX;
    private float unpressedOffsetY;
    private float checkedOffsetX;
    private float checkedOffsetY;
    private boolean programmaticChangeEvents;
    private boolean isDisabled;
    private boolean isChecked;
    private ChangeListener changeListener;
    private int tapSquareSize = 28;

    public B up(String name) {
        this.up = App.skin.getDrawable(name);
        return (B)this;
    }

    public B up(String name, Color color) {
        this.up = App.skin.newDrawable(name, color);
        return (B)this;
    }

    public B up(Drawable drawable) {
        this.up = drawable;
        return (B)this;
    }

    public B down(String name) {
        this.down = App.skin.getDrawable(name);
        return (B)this;
    }

    public B down(String name, Color color) {
        this.down = App.skin.newDrawable(name, color);
        return (B)this;
    }

    public B down(Drawable drawable) {
        this.down = drawable;
        return (B)this;
    }

    public B over(String name) {
        this.over = App.skin.getDrawable(name);
        return (B)this;
    }

    public B over(String name, Color color) {
        this.over = App.skin.newDrawable(name, color);
        return (B)this;
    }

    public B over(Drawable drawable) {
        this.over = drawable;
        return (B)this;
    }

    public B checked(String name) {
        this.checked = App.skin.getDrawable(name);
        return (B)this;
    }

    public B checked(String name, Color color) {
        this.checked = App.skin.newDrawable(name, color);
        return (B)this;
    }

    public B checked(Drawable drawable) {
        this.checked = drawable;
        return (B)this;
    }

    public B checkedOver(String name) {
        this.checkedOver = App.skin.getDrawable(name);
        return (B)this;
    }

    public B checkedOver(String name, Color color) {
        this.checkedOver = App.skin.newDrawable(name, color);
        return (B)this;
    }

    public B checkedOver(Drawable drawable) {
        this.checkedOver = drawable;
        return (B)this;
    }

    public B disabled(String name) {
        this.disabled = App.skin.getDrawable(name);
        return (B)this;
    }

    public B disabled(String name, Color color) {
        this.disabled = App.skin.newDrawable(name, color);
        return (B)this;
    }

    public B disabled(Drawable drawable) {
        this.disabled = drawable;
        return (B)this;
    }

    public B pressedOffset(float x, float y) {
        this.pressedOffsetX = x;
        this.pressedOffsetY = y;
        return (B)this;
    }

    public B unpressedOffset(float x, float y) {
        this.unpressedOffsetX = x;
        this.unpressedOffsetY = y;
        return (B)this;
    }

    public B checkedOffset(float x, float y) {
        this.checkedOffsetX = x;
        this.checkedOffsetY = y;
        return (B)this;
    }

    public B programmaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
        return (B)this;
    }

    public B disabled(boolean disabled) {
        this.isDisabled = disabled;
        return (B)this;
    }

    public B checked(boolean checked) {
        this.isChecked = checked;
        return (B)this;
    }

    public B tapSquareSize(int tapSquareSize) {
        this.tapSquareSize = tapSquareSize;
        return (B)this;
    }

    public B change(ChangeListener changeListener) {
        this.changeListener = changeListener;
        return (B)this;
    }

    public <S extends Button.ButtonStyle> S set(S style) {
        style.up = this.up;
        style.down = this.down;
        style.over = this.over;
        style.checked = this.checked;
        style.checkedOver = this.checkedOver;
        style.disabled = this.disabled;
        style.pressedOffsetX = this.pressedOffsetX;
        style.pressedOffsetY = this.pressedOffsetY;
        style.unpressedOffsetX = this.unpressedOffsetX;
        style.unpressedOffsetY = this.unpressedOffsetY;
        style.checkedOffsetX = this.checkedOffsetX;
        style.checkedOffsetY = this.checkedOffsetY;
        return style;
    }

    public T set(T button) {
        ((Button)button).getClickListener().setTapSquareSize(this.tapSquareSize);
        ((Button)button).setProgrammaticChangeEvents(this.programmaticChangeEvents);
        ((Button)button).setDisabled(this.isDisabled);
        ((Button)button).setChecked(this.isChecked);
        if (this.changeListener != null) {
            ((Actor)button).addListener(this.changeListener);
        }
        return button;
    }

    public T create() {
        Button.ButtonStyle style = this.set((T)new Button.ButtonStyle());
        return (T)this.set(new Button(style));
    }
}

