/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.tcpserver;

import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.tcpserver.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;

public abstract class Connection {
    private static final byte[] empty = new byte[0];
    final String category;
    private final String name;
    private final Socket socket;
    final DataInputStream input;
    final DataOutputStream output;
    final Object outputLock = new Object();
    final ArrayBlockingQueue sends = new ArrayBlockingQueue(1024, true);
    Thread writeThread;
    volatile boolean closed;
    byte[] data = empty;
    Object userObject;

    public Connection(String category, String name, Socket socket) throws IOException {
        this.category = category;
        this.name = name;
        this.socket = socket;
        try {
            this.input = new DataInputStream(socket.getInputStream());
            this.output = new DataOutputStream(socket.getOutputStream());
        }
        catch (IOException ex) {
            throw new IOException("Error opening socket streams.", ex);
        }
    }

    void start() {
        new Thread(String.valueOf(this.name) + "Read"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    try {
                        while (!Connection.this.closed) {
                            String payload;
                            String event;
                            String message = Connection.this.input.readUTF();
                            if (message == null) return;
                            if (Connection.this.closed) {
                                return;
                            }
                            int index = message.indexOf(" ");
                            if (index != -1) {
                                event = message.substring(0, index).trim();
                                payload = message.substring(index + 1).trim();
                            } else {
                                event = message.trim();
                                payload = "";
                            }
                            int dataLength = Util.readVarint(Connection.this.input);
                            if (dataLength > 0) {
                                int count;
                                if (Connection.this.closed) {
                                    return;
                                }
                                if (Connection.this.data.length < dataLength) {
                                    Connection.this.data = new byte[dataLength];
                                }
                                int offset = 0;
                                int remaining = dataLength;
                                while ((count = Connection.this.input.read(Connection.this.data, offset, remaining)) != -1 && !Connection.this.closed && (remaining -= count) != 0) {
                                    offset += count;
                                }
                            }
                            if (Log.TRACE) {
                                Log.trace(Connection.this.category, "Received: " + event + ", " + payload + (dataLength > 0 ? ", " + dataLength : ""));
                            }
                            try {
                                Connection.this.receive(event, payload, Connection.this.data, dataLength);
                            }
                            catch (Throwable ex) {
                                if (!Log.ERROR) return;
                                Log.error(Connection.this.category, "Error processing message: " + message, ex);
                                return;
                            }
                        }
                        return;
                    }
                    catch (EOFException ex) {
                        if (Log.TRACE) {
                            Log.trace(Connection.this.category, "Connection has closed.", ex);
                        }
                        Connection.this.close();
                        if (!Log.TRACE) return;
                        Log.trace(Connection.this.category, "Read thread stopped.");
                        return;
                    }
                    catch (IOException ex) {
                        if (!Connection.this.closed) {
                            if (ex.getMessage() != null && ex.getMessage().contains("Connection reset")) {
                                if (Log.TRACE) {
                                    Log.trace(Connection.this.category, "Client connection reset.", ex);
                                }
                            } else if (Log.ERROR) {
                                Log.error(Connection.this.category, "Error reading from connection.", ex);
                            }
                        }
                        Connection.this.close();
                        if (!Log.TRACE) return;
                        Log.trace(Connection.this.category, "Read thread stopped.");
                        return;
                    }
                }
                finally {
                    Connection.this.close();
                    if (Log.TRACE) {
                        Log.trace(Connection.this.category, "Read thread stopped.");
                    }
                }
            }
        }.start();
        this.writeThread = new Thread(String.valueOf(this.name) + "Write"){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        this.writeThread.start();
    }

    public void send(String message) {
        if (Log.TRACE) {
            Log.trace(this.category, "Queued: " + message);
        }
        this.sends.add(message);
    }

    public void send(String message, byte[] bytes) {
        this.send(message, bytes, 0, bytes.length);
    }

    public void send(String message, byte[] bytes, int offset, int count) {
        if (count != 0 && bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null when count != 0: " + count);
        }
        if (Log.TRACE) {
            Log.trace(this.category, "Queued: " + message + ", " + count);
        }
        Send send = new Send();
        send.message = message;
        send.bytes = bytes;
        send.offset = offset;
        send.count = count;
        this.sends.add(send);
    }

    public boolean sendBlocking(String message) {
        return this.sendBlocking(message, null, 0, 0);
    }

    public boolean sendBlocking(String message, byte[] bytes) {
        return this.sendBlocking(message, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBlocking(String message, byte[] bytes, int offset, int count) {
        if (count != 0 && bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null when count != 0: " + count);
        }
        if (this.closed) {
            return false;
        }
        try {
            Object object = this.outputLock;
            synchronized (object) {
                if (Log.TRACE) {
                    Log.trace(this.category, "Sent: " + message + (count > 0 ? ", " + count : ""));
                }
                this.output.writeUTF(message);
                Util.writeVarint(count, this.output);
                if (count != 0) {
                    this.output.write(bytes, offset, count);
                }
                this.output.flush();
            }
            return true;
        }
        catch (IOException ex) {
            if (Log.ERROR && !this.closed) {
                Log.error(this.category, "Error writing to connection: " + message, ex);
            }
            this.close();
            return false;
        }
    }

    public abstract void receive(String var1, String var2, byte[] var3, int var4);

    public void close() {
        if (Log.INFO && !this.closed) {
            Log.info(this.category, "Client disconnected.");
        }
        this.closed = true;
        if (this.writeThread != null) {
            this.writeThread.interrupt();
        }
        Util.closeQuietly(this.output);
        Util.closeQuietly(this.input);
        Util.closeQuietly(this.socket);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    static class Send {
        String message;
        byte[] bytes;
        int offset;
        int count;

        Send() {
        }
    }
}

