/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.TimeUtils;

public class InputEventQueue
implements InputProcessor {
    private static final int SKIP = -1;
    private static final int KEY_DOWN = 0;
    private static final int KEY_UP = 1;
    private static final int KEY_TYPED = 2;
    private static final int TOUCH_DOWN = 3;
    private static final int TOUCH_UP = 4;
    private static final int TOUCH_DRAGGED = 5;
    private static final int MOUSE_MOVED = 6;
    private static final int SCROLLED = 7;
    private InputProcessor processor;
    private final IntArray queue = new IntArray();
    private final IntArray processingQueue = new IntArray();
    private long currentEventTime;

    public InputEventQueue() {
    }

    public InputEventQueue(InputProcessor processor) {
        this.processor = processor;
    }

    public void setProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    public InputProcessor getProcessor() {
        return this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        InputEventQueue inputEventQueue = this;
        synchronized (inputEventQueue) {
            if (this.processor == null) {
                this.queue.clear();
                return;
            }
            this.processingQueue.addAll(this.queue);
            this.queue.clear();
        }
        int[] q = this.processingQueue.items;
        InputProcessor localProcessor = this.processor;
        int i = 0;
        int n = this.processingQueue.size;
        while (i < n) {
            int type = q[i++];
            this.currentEventTime = (long)q[i++] << 32 | (long)q[i++] & 0xFFFFFFFFL;
            switch (type) {
                case -1: {
                    i += q[i];
                    break;
                }
                case 0: {
                    localProcessor.keyDown(q[i++]);
                    break;
                }
                case 1: {
                    localProcessor.keyUp(q[i++]);
                    break;
                }
                case 2: {
                    localProcessor.keyTyped((char)q[i++]);
                    break;
                }
                case 3: {
                    localProcessor.touchDown(q[i++], q[i++], q[i++], q[i++]);
                    break;
                }
                case 4: {
                    localProcessor.touchUp(q[i++], q[i++], q[i++], q[i++]);
                    break;
                }
                case 5: {
                    localProcessor.touchDragged(q[i++], q[i++], q[i++]);
                    break;
                }
                case 6: {
                    localProcessor.mouseMoved(q[i++], q[i++]);
                    break;
                }
                case 7: {
                    localProcessor.scrolled(NumberUtils.intBitsToFloat(q[i++]), NumberUtils.intBitsToFloat(q[i++]));
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.processingQueue.clear();
    }

    private synchronized int next(int nextType, int i) {
        int[] q = this.queue.items;
        int n = this.queue.size;
        while (i < n) {
            int type = q[i];
            if (type == nextType) {
                return i;
            }
            i += 3;
            switch (type) {
                case -1: {
                    i += q[i];
                    break;
                }
                case 0: {
                    ++i;
                    break;
                }
                case 1: {
                    ++i;
                    break;
                }
                case 2: {
                    ++i;
                    break;
                }
                case 3: {
                    i += 4;
                    break;
                }
                case 4: {
                    i += 4;
                    break;
                }
                case 5: {
                    i += 3;
                    break;
                }
                case 6: {
                    i += 2;
                    break;
                }
                case 7: {
                    i += 2;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        return -1;
    }

    private void queueTime() {
        long time = TimeUtils.nanoTime();
        this.queue.add((int)(time >> 32));
        this.queue.add((int)time);
    }

    @Override
    public synchronized boolean keyDown(int keycode) {
        this.queue.add(0);
        this.queueTime();
        this.queue.add(keycode);
        return false;
    }

    @Override
    public synchronized boolean keyUp(int keycode) {
        this.queue.add(1);
        this.queueTime();
        this.queue.add(keycode);
        return false;
    }

    @Override
    public synchronized boolean keyTyped(char character) {
        this.queue.add(2);
        this.queueTime();
        this.queue.add(character);
        return false;
    }

    @Override
    public synchronized boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.queue.add(3);
        this.queueTime();
        this.queue.add(screenX);
        this.queue.add(screenY);
        this.queue.add(pointer);
        this.queue.add(button);
        return false;
    }

    @Override
    public synchronized boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.queue.add(4);
        this.queueTime();
        this.queue.add(screenX);
        this.queue.add(screenY);
        this.queue.add(pointer);
        this.queue.add(button);
        return false;
    }

    @Override
    public synchronized boolean touchDragged(int screenX, int screenY, int pointer) {
        int i = this.next(5, 0);
        while (i >= 0) {
            if (this.queue.get(i + 5) == pointer) {
                this.queue.set(i, -1);
                this.queue.set(i + 3, 3);
            }
            i = this.next(5, i + 6);
        }
        this.queue.add(5);
        this.queueTime();
        this.queue.add(screenX);
        this.queue.add(screenY);
        this.queue.add(pointer);
        return false;
    }

    @Override
    public synchronized boolean mouseMoved(int screenX, int screenY) {
        int i = this.next(6, 0);
        while (i >= 0) {
            this.queue.set(i, -1);
            this.queue.set(i + 3, 2);
            i = this.next(6, i + 5);
        }
        this.queue.add(6);
        this.queueTime();
        this.queue.add(screenX);
        this.queue.add(screenY);
        return false;
    }

    @Override
    public synchronized boolean scrolled(float amountX, float amountY) {
        this.queue.add(7);
        this.queueTime();
        this.queue.add(NumberUtils.floatToIntBits(amountX));
        this.queue.add(NumberUtils.floatToIntBits(amountY));
        return false;
    }

    public long getCurrentEventTime() {
        return this.currentEventTime;
    }
}

