/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen;

import com.badlogic.gdx.jnigen.AndroidNdkScriptGenerator;
import com.badlogic.gdx.jnigen.BuildConfig;
import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.FileDescriptor;
import java.util.ArrayList;

public class AntScriptGenerator {
    public void generate(BuildConfig config, BuildTarget ... targets) {
        if (!config.libsDir.exists() && !config.libsDir.mkdirs()) {
            throw new RuntimeException("Couldn't create directory for shared library files in '" + config.libsDir + "'");
        }
        if (!config.jniDir.exists() && !config.jniDir.mkdirs()) {
            throw new RuntimeException("Couldn't create native code directory '" + config.jniDir + "'");
        }
        this.copyJniHeaders(config.jniDir.path());
        if (!config.jniDir.child("memcpy_wrap.c").exists()) {
            new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/memcpy_wrap.c", FileDescriptor.FileType.Classpath).copyTo(config.jniDir.child("memcpy_wrap.c"));
        }
        ArrayList<String> buildFiles = new ArrayList<String>();
        ArrayList<String> libsDirs = new ArrayList<String>();
        ArrayList<String> sharedLibFiles = new ArrayList<String>();
        BuildTarget[] buildTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            BuildTarget target = buildTargetArray[n2];
            String buildFile = this.generateBuildTargetTemplate(config, target);
            FileDescriptor libsDir = new FileDescriptor(this.getLibsDirectory(config, target));
            if (!libsDir.exists() && !libsDir.mkdirs()) {
                throw new RuntimeException("Couldn't create libs directory '" + libsDir + "'");
            }
            String buildFileName = "build-" + target.os.toString().toLowerCase() + (target.isARM ? "arm" : "") + (target.is64Bit ? "64" : "32") + ".xml";
            if (target.buildFileName != null) {
                buildFileName = target.buildFileName;
            }
            config.jniDir.child(buildFileName).writeString(buildFile, false);
            System.out.println("Wrote target '" + (Object)((Object)target.os) + (target.isARM ? "Arm" : "") + (target.is64Bit ? "64" : "32") + "' build script '" + config.jniDir.child(buildFileName) + "'");
            if (!target.excludeFromMasterBuildFile) {
                String sharedLibFilename;
                if (target.os != BuildTarget.TargetOs.MacOsX && target.os != BuildTarget.TargetOs.IOS) {
                    buildFiles.add(buildFileName);
                }
                if ((sharedLibFilename = target.libName) == null) {
                    sharedLibFilename = this.getSharedLibFilename(target.os, target.is64Bit, target.isARM, config.sharedLibName);
                }
                sharedLibFiles.add(sharedLibFilename);
                if (target.os != BuildTarget.TargetOs.Android && target.os != BuildTarget.TargetOs.IOS) {
                    libsDirs.add("../" + libsDir.path().replace('\\', '/'));
                }
            }
            ++n2;
        }
        String template = new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/build.xml.template", FileDescriptor.FileType.Classpath).readString();
        StringBuilder clean = new StringBuilder();
        StringBuilder compile = new StringBuilder();
        StringBuilder pack = new StringBuilder();
        int i = 0;
        while (i < buildFiles.size()) {
            clean.append("\t\t<ant antfile=\"" + (String)buildFiles.get(i) + "\" target=\"clean\"/>\n");
            compile.append("\t\t<ant antfile=\"" + (String)buildFiles.get(i) + "\"/>\n");
            ++i;
        }
        i = 0;
        while (i < libsDirs.size()) {
            pack.append("\t\t\t<fileset dir=\"" + (String)libsDirs.get(i) + "\" erroronmissingdir=\"false\" includes=\"" + (String)sharedLibFiles.get(i) + "\"/>\n");
            ++i;
        }
        if (config.sharedLibs != null) {
            String[] stringArray = config.sharedLibs;
            int n3 = config.sharedLibs.length;
            int n4 = 0;
            while (n4 < n3) {
                String sharedLib = stringArray[n4];
                pack.append("\t\t\t<fileset dir=\"" + sharedLib + "\"/>\n");
                ++n4;
            }
        }
        template = template.replace("%projectName%", String.valueOf(config.sharedLibName) + "-natives");
        template = template.replace("<clean/>", clean.toString());
        template = template.replace("<compile/>", compile.toString());
        template = template.replace("%packFile%", "../" + config.libsDir.path().replace('\\', '/') + "/" + config.sharedLibName + "-natives.jar");
        template = template.replace("<pack/>", pack);
        config.jniDir.child("build.xml").writeString(template, false);
        System.out.println("Wrote master build script '" + config.jniDir.child("build.xml") + "'");
    }

    private void copyJniHeaders(String jniDir) {
        String[] files;
        String pack = "com/badlogic/gdx/jnigen/resources/headers";
        String[] stringArray = files = new String[]{"classfile_constants.h", "jawt.h", "jdwpTransport.h", "jni.h", "linux/jawt_md.h", "linux/jni_md.h", "mac/jni_md.h", "win32/jawt_md.h", "win32/jni_md.h"};
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            new FileDescriptor("com/badlogic/gdx/jnigen/resources/headers", FileDescriptor.FileType.Classpath).child(file).copyTo(new FileDescriptor(jniDir).child("jni-headers").child(file));
            ++n2;
        }
    }

    private String getSharedLibFilename(BuildTarget.TargetOs os, boolean is64Bit, boolean isARM, String sharedLibName) {
        String libPrefix = "";
        String libSuffix = "";
        if (os == BuildTarget.TargetOs.Windows) {
            libSuffix = String.valueOf(is64Bit ? "64" : "") + ".dll";
        }
        if (os == BuildTarget.TargetOs.Linux || os == BuildTarget.TargetOs.Android) {
            libPrefix = "lib";
            libSuffix = String.valueOf(isARM ? "arm" : "") + (is64Bit ? "64" : "") + ".so";
        }
        if (os == BuildTarget.TargetOs.MacOsX) {
            libPrefix = "lib";
            libSuffix = String.valueOf(is64Bit ? "64" : "") + ".dylib";
        }
        if (os == BuildTarget.TargetOs.IOS) {
            libPrefix = "lib";
            libSuffix = ".a";
        }
        return String.valueOf(libPrefix) + sharedLibName + libSuffix;
    }

    private String getJniPlatform(BuildTarget.TargetOs os) {
        if (os == BuildTarget.TargetOs.Windows) {
            return "win32";
        }
        if (os == BuildTarget.TargetOs.Linux) {
            return "linux";
        }
        if (os == BuildTarget.TargetOs.MacOsX) {
            return "mac";
        }
        return "";
    }

    private String getLibsDirectory(BuildConfig config, BuildTarget target) {
        String targetName = target.osFileName;
        if (targetName == null) {
            targetName = String.valueOf(target.os.toString().toLowerCase()) + (target.isARM ? "arm" : "") + (target.is64Bit ? "64" : "32");
        }
        return config.libsDir.child(targetName).path().replace('\\', '/');
    }

    private String generateBuildTargetTemplate(BuildConfig config, BuildTarget target) {
        if (target.os == BuildTarget.TargetOs.Android) {
            new AndroidNdkScriptGenerator().generate(config, target);
            String template = new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/build-android.xml.template", FileDescriptor.FileType.Classpath).readString();
            template = template.replace("%precompile%", target.preCompileTask == null ? "" : target.preCompileTask);
            template = template.replace("%postcompile%", target.postCompileTask == null ? "" : target.postCompileTask);
            return template;
        }
        String template = null;
        template = target.os == BuildTarget.TargetOs.IOS ? new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/build-ios.xml.template", FileDescriptor.FileType.Classpath).readString() : new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/build-target.xml.template", FileDescriptor.FileType.Classpath).readString();
        String libName = target.libName;
        if (libName == null) {
            libName = this.getSharedLibFilename(target.os, target.is64Bit, target.isARM, config.sharedLibName);
        }
        String jniPlatform = this.getJniPlatform(target.os);
        StringBuilder cIncludes = new StringBuilder();
        cIncludes.append("\t\t<include name=\"memcpy_wrap.c\"/>\n");
        String[] stringArray = target.cIncludes;
        int n = target.cIncludes.length;
        int n2 = 0;
        while (n2 < n) {
            String cInclude = stringArray[n2];
            cIncludes.append("\t\t<include name=\"" + cInclude + "\"/>\n");
            ++n2;
        }
        StringBuilder cppIncludes = new StringBuilder();
        String[] stringArray2 = target.cppIncludes;
        int n3 = target.cppIncludes.length;
        n = 0;
        while (n < n3) {
            String cppInclude = stringArray2[n];
            cppIncludes.append("\t\t<include name=\"" + cppInclude + "\"/>\n");
            ++n;
        }
        StringBuilder cExcludes = new StringBuilder();
        String[] stringArray3 = target.cExcludes;
        int n4 = target.cExcludes.length;
        n3 = 0;
        while (n3 < n4) {
            String cExclude = stringArray3[n3];
            cExcludes.append("\t\t<exclude name=\"" + cExclude + "\"/>\n");
            ++n3;
        }
        StringBuilder cppExcludes = new StringBuilder();
        String[] stringArray4 = target.cppExcludes;
        int n5 = target.cppExcludes.length;
        n4 = 0;
        while (n4 < n5) {
            String cppExclude = stringArray4[n4];
            cppExcludes.append("\t\t<exclude name=\"" + cppExclude + "\"/>\n");
            ++n4;
        }
        StringBuilder headerDirs = new StringBuilder();
        String[] stringArray5 = target.headerDirs;
        int n6 = target.headerDirs.length;
        n5 = 0;
        while (n5 < n6) {
            String headerDir = stringArray5[n5];
            headerDirs.append("\t\t\t<arg value=\"-I" + headerDir + "\"/>\n");
            ++n5;
        }
        String targetFolder = target.osFileName;
        if (targetFolder == null) {
            targetFolder = String.valueOf(target.os.toString().toLowerCase()) + (target.isARM ? "arm" : "") + (target.is64Bit ? "64" : "32");
        }
        template = template.replace("%projectName%", String.valueOf(config.sharedLibName) + "-" + (Object)((Object)target.os) + "-" + (target.isARM ? "arm" : "") + (target.is64Bit ? "64" : "32"));
        template = template.replace("%buildDir%", config.buildDir.child(targetFolder).path().replace('\\', '/'));
        template = template.replace("%libsDir%", "../" + this.getLibsDirectory(config, target));
        template = template.replace("%libName%", libName);
        template = template.replace("%jniPlatform%", jniPlatform);
        template = template.replace("%compilerPrefix%", target.compilerPrefix);
        template = template.replace("%cFlags%", target.cFlags);
        template = template.replace("%cppFlags%", target.cppFlags);
        template = template.replace("%linkerFlags%", target.linkerFlags);
        template = template.replace("%libraries%", target.libraries);
        template = template.replace("%cIncludes%", cIncludes);
        template = template.replace("%cExcludes%", cExcludes);
        template = template.replace("%cppIncludes%", cppIncludes);
        template = template.replace("%cppExcludes%", cppExcludes);
        template = template.replace("%headerDirs%", headerDirs);
        template = template.replace("%precompile%", target.preCompileTask == null ? "" : target.preCompileTask);
        template = template.replace("%postcompile%", target.postCompileTask == null ? "" : target.postCompileTask);
        return template;
    }
}

