/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.network.Network;
import com.esotericsoftware.gloomhavenhelper.util.Menu;
import com.esotericsoftware.gloomhavenhelper.util.TextMenu;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.utils.SkeletonActor;

public class Intro {
    private Container ghhLogo;
    Container esotericLogo;
    private Image stageCover;
    private float introTime;
    private float introDuration;
    private float logoFadeTime = 2.0f;
    public int introPhase = 0;
    float skeletonScale = Math.round(Math.min(App.stage.getWidth(), App.stage.getHeight()) / 2.0f / 260.0f);
    private boolean welcomeShown;

    public Intro() {
        SkeletonActor esotericSkeleton = new SkeletonActor(App.skeletonRenderer, new Skeleton(App.esotericSkeletonData), new AnimationState(new AnimationStateData(App.esotericSkeletonData)));
        esotericSkeleton.getSkeleton().getRootBone().setScale(this.skeletonScale);
        if (this.skeletonScale > 1.0f) {
            App.atlas.findRegion("esoteric/logo").getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
        this.esotericLogo = new Container<SkeletonActor>(esotericSkeleton);
        this.esotericLogo.setTouchable(Touchable.disabled);
        this.esotericLogo.setFillParent(true);
        this.ghhLogo = new Container<Image>(new Image(App.skin, "separate/logo")).padLeft(13.0f);
        this.ghhLogo.setTouchable(Touchable.disabled);
        this.ghhLogo.getColor().a = 0.0f;
        this.ghhLogo.setFillParent(true);
        this.stageCover = new Image(App.skin.newDrawable("white", Color.BLACK));
        this.stageCover.setFillParent(true);
    }

    public void update(float delta) {
        boolean hasRows;
        boolean bl = hasRows = App.gloom.rows.getChildren().size != 0;
        if (!hasRows || this.introPhase != -1) {
            if (Menu.menusShown > 0) {
                this.ghhLogo.remove();
                if (this.esotericLogo != null) {
                    this.esotericLogo.remove();
                }
            } else {
                App.stage.addActor(this.ghhLogo);
                this.ghhLogo.toFront();
                if (this.esotericLogo != null) {
                    App.stage.addActor(this.esotericLogo);
                    this.esotericLogo.toFront();
                }
            }
            if (!hasRows) {
                this.logoFadeTime = 1.4f;
            }
            if (this.introPhase == -1) {
                if (this.esotericLogo != null) {
                    this.esotericLogo.getColor().a = 1.0f;
                }
                this.ghhLogo.getColor().a = 1.0f;
            }
        }
        if (this.introPhase != -1) {
            float timeScale = hasRows ? (this.introPhase <= 3 ? 1.3f : 1.0f) : (this.introPhase <= 1 ? 0.75f : 1.0f);
            this.introTime -= delta * timeScale;
            float percent = this.introDuration == 0.0f ? 1.0f : 1.0f - Math.max(0.0f, this.introTime / this.introDuration);
            float nextDuration = 0.0f;
            switch (this.introPhase) {
                case 0: {
                    ((SkeletonActor)this.esotericLogo.getActor()).getAnimationState().setAnimation(0, "logo", false).setTimeScale(timeScale);
                    nextDuration = 2.7333333f;
                    break;
                }
                case 1: {
                    nextDuration = 0.0f;
                    break;
                }
                case 2: {
                    ((SkeletonActor)this.esotericLogo.getActor()).getAnimationState().getCurrent(0).setTimeScale(timeScale);
                    this.esotericLogo.addAction(Actions.sequence((Action)Actions.delay(0.93333334f / timeScale), new Action(){

                        @Override
                        public boolean act(float delta) {
                            App.atlas.findRegion("esoteric/logo").getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                            return true;
                        }
                    }, (Action)Actions.delay(-1.2333333f / timeScale), new Action(){

                        @Override
                        public boolean act(float delta) {
                            if (App.gloom.nearest()) {
                                App.atlas.findRegion("esoteric/logo").getTexture().setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
                            }
                            return true;
                        }
                    }));
                    Object image = this.esotericLogo.getActor();
                    float startX = ((Actor)image).getX();
                    float startY = ((Actor)image).getY();
                    this.esotericLogo.bottom().right().pad(0.0f, 0.0f, 195.0f, 130.0f);
                    this.esotericLogo.invalidate();
                    this.esotericLogo.validate();
                    float endX = ((Actor)image).getX();
                    float endY = ((Actor)image).getY();
                    ((Actor)image).setPosition(startX, startY);
                    ((Actor)image).addAction(Actions.sequence((Action)Actions.moveTo(endX, endY, 0.75f / timeScale, Interpolation.fastSlow), new Action(){

                        @Override
                        public boolean act(float delta) {
                            Intro.this.esotericLogo.invalidate();
                            return true;
                        }
                    }));
                    this.esotericLogo.addAction(new TemporalAction(0.75f / timeScale, Interpolation.fastSlow){

                        @Override
                        protected void update(float percent) {
                            ((SkeletonActor)Intro.this.esotericLogo.getActor()).getSkeleton().getRootBone().setScale(Intro.this.skeletonScale - (Intro.this.skeletonScale - 1.0f) * percent);
                        }
                    });
                    App.stage.getRoot().addActorAt(0, App.root);
                    App.stage.getRoot().addActorAt(1, this.stageCover);
                    this.stageCover.validate();
                    this.stageCover.addAction(Actions.sequence((Action)Actions.alpha(0.2f, 3.0f / timeScale), (Action)Actions.delay(2.0f), (Action)Actions.alpha(0.0f, 5.0f / timeScale, Interpolation.slowFast), (Action)Actions.removeActor()));
                    nextDuration = 1.2f;
                    break;
                }
                case 3: {
                    nextDuration = 1.4f;
                    break;
                }
                case 4: {
                    this.stageCover.setTouchable(Touchable.disabled);
                    this.ghhLogo.getColor().a = Interpolation.fastSlow.apply(percent);
                    nextDuration = 2.0f;
                    break;
                }
                case 5: {
                    if (!this.welcomeShown) {
                        boolean android;
                        this.welcomeShown = true;
                        boolean bl2 = android = Gdx.app.getType() == Application.ApplicationType.Android;
                        if (android && !App.config.welcome && !App.game.isPurchased()) {
                            App.config.welcome = true;
                            App.game.saveConfig();
                            final TextMenu menu = new TextMenu(){

                                @Override
                                protected void updatePosition() {
                                    float width = this.getPrefWidth();
                                    float height = this.getPrefHeight();
                                    if (width > App.stage.getWidth() - 18.0f) {
                                        width = App.stage.getWidth() - 18.0f;
                                    }
                                    if (height > App.stage.getHeight() - 18.0f) {
                                        height = App.stage.getHeight() - 18.0f;
                                    }
                                    this.setPosition(Math.round((App.stage.getWidth() - width) / 2.0f), Math.round((App.stage.getHeight() - height) / 2.0f));
                                }
                            };
                            menu.showArrow = false;
                            menu.autoHide = false;
                            Button okButton = App.textButton("OK").create();
                            okButton.pad(10.0f, 40.0f, 10.0f, 18.0f);
                            okButton.addListener(new ChangeListener(){

                                @Override
                                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                    menu.hide();
                                }
                            });
                            menu.table.add(new Container<Label>(new Label((CharSequence)"Welcome to Gloomhaven Helper", App.skin, "plainLargeOutline", Color.WHITE)).pad(16.0f, 16.0f, 0.0f, 16.0f)).row();
                            menu.table.defaults().fill(false).left();
                            menu.table.add(new Container<Label>(new Label((CharSequence)"The ads can be removed from the main menu.", App.skin, "plainMediumOutline", App.lightGray)).pad(16.0f, 16.0f, 0.0f, 16.0f)).row();
                            menu.table.add(new Container<Label>(new Label((CharSequence)"Sorry for the ads, but thank you for supporting\nGloomhaven Helper's development!", App.skin, "plainMediumOutline", App.lightGray)).pad(16.0f, 16.0f, 0.0f, 16.0f)).row();
                            menu.table.add(okButton).right().row();
                            menu.pack();
                            menu.show(null, 0.0f, 0.0f, 0.0f, 0.0f, false);
                        } else if ((android || Gdx.app.getType() == Application.ApplicationType.WebGL) && App.config.toasts < 3) {
                            ++App.config.toasts;
                            App.game.saveConfig();
                        }
                    }
                    nextDuration = -1.0f;
                }
            }
            if (percent == 1.0f) {
                if (nextDuration == -1.0f) {
                    this.introPhase = -1;
                    Network.update();
                } else {
                    ++this.introPhase;
                    this.introDuration = this.introTime = nextDuration;
                }
            }
            Gdx.graphics.requestRendering();
        } else if (hasRows && this.logoFadeTime > 0.0f) {
            this.logoFadeTime -= delta;
            if (this.logoFadeTime <= 0.0f) {
                this.ghhLogo.remove();
                if (this.esotericLogo != null) {
                    this.esotericLogo.remove();
                    this.esotericLogo = null;
                    App.atlas.findRegion("esoteric/logo").getTexture().dispose();
                    App.esotericSkeletonData = null;
                }
            } else {
                float a;
                this.ghhLogo.getColor().a = a = Interpolation.slowFast.apply(Math.min(1.0f, this.logoFadeTime / 1.4f));
                if (this.esotericLogo != null) {
                    this.esotericLogo.getColor().a = a;
                }
            }
            Gdx.graphics.requestRendering();
        }
    }
}

