/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.tcpserver;

import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.tcpserver.Connection;
import com.esotericsoftware.tcpserver.Retry;
import com.esotericsoftware.tcpserver.TcpClient;
import com.esotericsoftware.tcpserver.Util;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class TcpServer
extends Retry {
    final CopyOnWriteArrayList<Connection> connections = new CopyOnWriteArrayList();
    private int port;
    private ServerSocket server;

    public TcpServer(String category, String name) {
        this(category, name, 0);
    }

    public TcpServer(String category, String name, int port) {
        super(category, name);
        this.port = port;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void retry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void stopped() {
        int i = this.connections.size() - 1;
        while (i >= 0) {
            this.connections.get(i).close();
            --i;
        }
        this.connections.clear();
        Util.closeQuietly(this.server);
    }

    public void connected(Connection connection) {
    }

    public void disconnected(Connection connection) {
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void send(String message) {
        for (Connection connection : this.connections) {
            connection.send(message);
        }
    }

    public void send(String message, byte[] bytes) {
        this.send(message, bytes, 0, bytes.length);
    }

    public void send(String message, byte[] bytes, int offset, int count) {
        for (Connection connection : this.connections) {
            connection.send(message, bytes, offset, count);
        }
    }

    public boolean sendBlocking(String message) {
        boolean success = true;
        for (Connection connection : this.connections) {
            if (connection.sendBlocking(message)) continue;
            success = false;
        }
        return success;
    }

    public boolean sendBlocking(String message, byte[] bytes) {
        return this.sendBlocking(message, bytes, 0, bytes.length);
    }

    public boolean sendBlocking(String message, byte[] bytes, int offset, int count) {
        boolean success = true;
        for (Connection connection : this.connections) {
            if (connection.sendBlocking(message, bytes, offset, count)) continue;
            success = false;
        }
        return success;
    }

    public abstract void receive(Connection var1, String var2, String var3, byte[] var4, int var5);

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static void main(String[] args) throws Exception {
        Log.TRACE();
        TcpServer server = new TcpServer("server", "TestServer", 4567){

            @Override
            public void receive(Connection connection, String event, String payload, byte[] bytes, int count) {
                System.out.println("Server received: " + event + ", " + payload + ", " + count);
                this.send("ok good");
            }
        };
        server.start();
        TcpClient client = new TcpClient("client", "TestClient", "localhost", 4567){

            @Override
            public void receive(String event, String payload, byte[] bytes, int count) {
                System.out.println("Client received: " + event + ", " + payload + ", " + count);
                this.getConnection().close();
            }
        };
        client.start();
        client.waitForConnection(0L);
        client.sendBlocking("yay moo");
    }

    private class ServerConnection
    extends Connection {
        public ServerConnection(String category, String name, Socket socket) throws IOException {
            super(category, name, socket);
        }

        public boolean isValid() {
            return TcpServer.this.connections.contains(this);
        }

        @Override
        public void receive(String event, String payload, byte[] bytes, int count) {
            TcpServer.this.receive(this, event, payload, bytes, count);
        }

        @Override
        public void close() {
            boolean wasClosed = this.closed;
            super.close();
            if (!wasClosed) {
                TcpServer.this.disconnected(this);
                TcpServer.this.connections.remove(this);
            }
        }
    }
}

