/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.tasks.DefaultScalaSourceSet;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.api.tasks.ScalaSourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.jvm.tasks.Jar;

public class ScalaBasePlugin
implements Plugin<Project> {
    @VisibleForTesting
    public static final String ZINC_CONFIGURATION_NAME = "zinc";
    public static final String SCALA_RUNTIME_EXTENSION_NAME = "scalaRuntime";
    private final SourceDirectorySetFactory sourceDirectorySetFactory;

    @Inject
    public ScalaBasePlugin(SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.sourceDirectorySetFactory = sourceDirectorySetFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        ScalaBasePlugin.configureConfigurations(project);
        ScalaRuntime scalaRuntime = ScalaBasePlugin.configureScalaRuntimeExtension(project);
        ScalaBasePlugin.configureCompileDefaults(project, scalaRuntime);
        ScalaBasePlugin.configureSourceSetDefaults(project, this.sourceDirectorySetFactory);
        ScalaBasePlugin.configureScaladoc(project, scalaRuntime);
    }

    private static void configureConfigurations(final Project project) {
        ((Configuration)project.getConfigurations().create(ZINC_CONFIGURATION_NAME)).setVisible(false).setDescription("The Zinc incremental compiler to be used for this Scala project.").defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)project.getDependencies().create((Object)"com.typesafe.zinc:zinc:0.3.15"));
            }
        });
    }

    private static ScalaRuntime configureScalaRuntimeExtension(Project project) {
        return (ScalaRuntime)project.getExtensions().create(SCALA_RUNTIME_EXTENSION_NAME, ScalaRuntime.class, new Object[]{project});
    }

    private static void configureSourceSetDefaults(final Project project, final SourceDirectorySetFactory sourceDirectorySetFactory) {
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(final SourceSet sourceSet) {
                String displayName = (String)InvokerHelper.invokeMethod((Object)sourceSet, (String)"getDisplayName", null);
                Convention sourceSetConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
                DefaultScalaSourceSet scalaSourceSet = new DefaultScalaSourceSet(displayName, sourceDirectorySetFactory);
                sourceSetConvention.getPlugins().put("scala", scalaSourceSet);
                final SourceDirectorySet scalaDirectorySet = scalaSourceSet.getScala();
                scalaDirectorySet.srcDir((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return project.file((Object)("src/" + sourceSet.getName() + "/scala"));
                    }
                });
                sourceSet.getAllJava().source(scalaDirectorySet);
                sourceSet.getAllSource().source(scalaDirectorySet);
                sourceSet.getResources().getFilter().exclude((Spec)new Spec<FileTreeElement>(){

                    public boolean isSatisfiedBy(FileTreeElement element) {
                        return scalaDirectorySet.contains(element.getFile());
                    }
                });
                ScalaBasePlugin.configureScalaCompile(project, sourceSet);
            }
        });
    }

    private static void configureScalaCompile(final Project project, final SourceSet sourceSet) {
        Convention scalaConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
        final ScalaSourceSet scalaSourceSet = (ScalaSourceSet)scalaConvention.findPlugin(ScalaSourceSet.class);
        SourceSetUtil.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)scalaSourceSet.getScala(), (Project)project);
        final TaskProvider scalaCompile = project.getTasks().register(sourceSet.getCompileTaskName("scala"), ScalaCompile.class, (Action)new Action<ScalaCompile>(){

            public void execute(ScalaCompile scalaCompile) {
                scalaCompile.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
                SourceSetUtil.configureForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)scalaSourceSet.getScala(), (AbstractCompile)scalaCompile, (CompileOptions)scalaCompile.getOptions(), (Project)project);
                scalaCompile.setDescription("Compiles the " + scalaSourceSet.getScala() + ".");
                scalaCompile.setSource((FileTree)scalaSourceSet.getScala());
                IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                if (incrementalOptions.getAnalysisFile() == null) {
                    String analysisFilePath = project.getBuildDir().getPath() + "/tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".analysis";
                    incrementalOptions.setAnalysisFile(new File(analysisFilePath));
                }
                if (incrementalOptions.getPublishedCode() == null) {
                    Jar jarTask = (Jar)project.getTasks().findByName(sourceSet.getJarTaskName());
                    incrementalOptions.setPublishedCode(jarTask == null ? null : jarTask.getArchivePath());
                }
            }
        });
        project.getTasks().named(sourceSet.getClassesTaskName()).configure((Action)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{scalaCompile});
            }
        });
    }

    private static void configureCompileDefaults(final Project project, final ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaCompile.class).configureEach((Action)new Action<ScalaCompile>(){

            public void execute(final ScalaCompile compile) {
                compile.getConventionMapping().map("scalaClasspath", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return scalaRuntime.inferScalaClasspath((Iterable<File>)compile.getClasspath());
                    }
                });
                compile.getConventionMapping().map("zincClasspath", (Callable)new Callable<Configuration>(){

                    @Override
                    public Configuration call() throws Exception {
                        return project.getConfigurations().getAt(ScalaBasePlugin.ZINC_CONFIGURATION_NAME);
                    }
                });
            }
        });
    }

    private static void configureScaladoc(final Project project, final ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaDoc.class).configureEach((Action)new Action<ScalaDoc>(){

            public void execute(final ScalaDoc scalaDoc) {
                scalaDoc.getConventionMapping().map("destinationDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        File docsDir = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getDocsDir();
                        return project.file((Object)(docsDir.getPath() + "/scaladoc"));
                    }
                });
                scalaDoc.getConventionMapping().map("title", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle();
                    }
                });
                scalaDoc.getConventionMapping().map("scalaClasspath", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return scalaRuntime.inferScalaClasspath((Iterable<File>)scalaDoc.getClasspath());
                    }
                });
            }
        });
    }
}

