/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependencies;

public class PendingDependenciesState {
    private static final PendingDependencies NOT_PENDING = PendingDependencies.notPending();
    private final Map<ModuleIdentifier, PendingDependencies> pendingDependencies = Maps.newHashMap();

    public PendingDependencies getPendingDependencies(ModuleIdentifier module) {
        PendingDependencies pendingDependencies = this.pendingDependencies.get(module);
        if (pendingDependencies == null) {
            pendingDependencies = PendingDependencies.pending();
            this.pendingDependencies.put(module, pendingDependencies);
        }
        return pendingDependencies;
    }

    public PendingDependencies notPending(ModuleIdentifier module) {
        return this.pendingDependencies.put(module, NOT_PENDING);
    }
}

