/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotData;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.MinimalPersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashCode;

public class DefaultClasspathEntrySnapshotCache
implements ClasspathEntrySnapshotCache {
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final MinimalPersistentCache<HashCode, ClasspathEntrySnapshotData> cache;

    public DefaultClasspathEntrySnapshotCache(FileSystemSnapshotter fileSystemSnapshotter, PersistentIndexedCache<HashCode, ClasspathEntrySnapshotData> persistentCache) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.cache = new MinimalPersistentCache(persistentCache);
    }

    @Override
    public Map<File, ClasspathEntrySnapshot> getClasspathEntrySnapshots(Map<File, HashCode> fileHashes) {
        LinkedHashMap out = Maps.newLinkedHashMap();
        for (Map.Entry<File, HashCode> entry : fileHashes.entrySet()) {
            ClasspathEntrySnapshotData snapshotData = (ClasspathEntrySnapshotData)this.cache.get((Object)entry.getValue());
            if (snapshotData == null) {
                throw new IllegalStateException("No incremental compile snapshot data available for " + entry.getKey() + " with hash " + entry.getValue() + ".");
            }
            ClasspathEntrySnapshot snapshot = new ClasspathEntrySnapshot(snapshotData);
            out.put(entry.getKey(), snapshot);
        }
        return out;
    }

    public ClasspathEntrySnapshot get(File key, final Factory<ClasspathEntrySnapshot> factory) {
        HashCode fileContentHash = this.fileSystemSnapshotter.snapshot(key).getHash();
        return new ClasspathEntrySnapshot((ClasspathEntrySnapshotData)this.cache.get((Object)fileContentHash, (Factory)new Factory<ClasspathEntrySnapshotData>(){

            public ClasspathEntrySnapshotData create() {
                return ((ClasspathEntrySnapshot)factory.create()).getData();
            }
        }));
    }
}

