/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.changedetection.state.CoercingStringValueSnapshot;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class DesugaredAttributeContainerSerializer
extends AbstractSerializer<AttributeContainer>
implements AttributeContainerSerializer {
    private final ImmutableAttributesFactory attributesFactory;
    private final NamedObjectInstantiator instantiator;
    private static final byte STRING_ATTRIBUTE = 1;
    private static final byte BOOLEAN_ATTRIBUTE = 2;

    public DesugaredAttributeContainerSerializer(ImmutableAttributesFactory attributesFactory, NamedObjectInstantiator instantiator) {
        this.attributesFactory = attributesFactory;
        this.instantiator = instantiator;
    }

    @Override
    public ImmutableAttributes read(Decoder decoder) throws IOException {
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        int count = decoder.readSmallInt();
        for (int i = 0; i < count; ++i) {
            String name = decoder.readString();
            byte type = decoder.readByte();
            if (type == 2) {
                attributes = this.attributesFactory.concat(attributes, Attribute.of((String)name, Boolean.class), (Object)decoder.readBoolean());
                continue;
            }
            String value = decoder.readString();
            attributes = this.attributesFactory.concat(attributes, Attribute.of((String)name, String.class), (Isolatable)new CoercingStringValueSnapshot(value, this.instantiator));
        }
        return attributes;
    }

    @Override
    public void write(Encoder encoder, AttributeContainer container) throws IOException {
        encoder.writeSmallInt(container.keySet().size());
        for (Attribute attribute : container.keySet()) {
            encoder.writeString((CharSequence)attribute.getName());
            if (attribute.getType().equals(Boolean.class)) {
                encoder.writeByte((byte)2);
                encoder.writeBoolean(((Boolean)container.getAttribute(attribute)).booleanValue());
                continue;
            }
            assert (attribute.getType().equals(String.class));
            encoder.writeByte((byte)1);
            encoder.writeString((CharSequence)((String)container.getAttribute(attribute)));
        }
    }
}

