/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftBinary;

public class DefaultSwiftBinary
implements SwiftBinary {
    private final String name;
    private final Provider<String> module;
    private final boolean debuggable;
    private final FileCollection source;
    private final FileCollection importPath;
    private final FileCollection linkLibs;
    private final Configuration runtimeLibs;

    public DefaultSwiftBinary(String name, ObjectFactory objectFactory, Provider<String> module, boolean debuggable, FileCollection source, ConfigurationContainer configurations, Configuration implementation) {
        this.name = name;
        this.module = module;
        this.debuggable = debuggable;
        this.source = source;
        Names names = Names.of(name);
        Configuration importPathConfig = (Configuration)configurations.create(names.withPrefix("swiftImport"));
        importPathConfig.extendsFrom(new Configuration[]{implementation});
        importPathConfig.setCanBeConsumed(false);
        importPathConfig.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
        importPathConfig.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        Configuration nativeLink = (Configuration)configurations.create(names.withPrefix("nativeLink"));
        nativeLink.extendsFrom(new Configuration[]{implementation});
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-link"));
        nativeLink.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        Configuration nativeRuntime = (Configuration)configurations.create(names.withPrefix("nativeRuntime"));
        nativeRuntime.extendsFrom(new Configuration[]{implementation});
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-runtime"));
        nativeRuntime.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        this.importPath = importPathConfig;
        this.linkLibs = nativeLink;
        this.runtimeLibs = nativeRuntime;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Provider<String> getModule() {
        return this.module;
    }

    @Override
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Override
    public FileCollection getSwiftSource() {
        return this.source;
    }

    @Override
    public FileCollection getCompileImportPath() {
        return this.importPath;
    }

    @Override
    public FileCollection getLinkLibraries() {
        return this.linkLibs;
    }

    @Override
    public FileCollection getRuntimeLibraries() {
        return this.runtimeLibs;
    }
}

