/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Map;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.internal.file.FileType;

public class OverlappingOutputs {
    private final String propertyName;
    private final String overlappedFilePath;

    public OverlappingOutputs(String propertyName, String overlappedFilePath) {
        this.propertyName = propertyName;
        this.overlappedFilePath = overlappedFilePath;
    }

    public static OverlappingOutputs detect(String propertyName, FileCollectionSnapshot previousExecution, FileCollectionSnapshot beforeExecution) {
        Map<String, NormalizedFileSnapshot> previousSnapshots = previousExecution.getSnapshots();
        Map<String, NormalizedFileSnapshot> beforeSnapshots = beforeExecution.getSnapshots();
        for (Map.Entry<String, NormalizedFileSnapshot> beforeSnapshot : beforeSnapshots.entrySet()) {
            String path = beforeSnapshot.getKey();
            NormalizedFileSnapshot fileSnapshot = beforeSnapshot.getValue();
            NormalizedFileSnapshot previousSnapshot = previousSnapshots.get(path);
            if (fileSnapshot.getSnapshot().getType() == FileType.Missing || !OverlappingOutputs.createdSincePreviousExecution(previousSnapshot) && !OverlappingOutputs.changedSincePreviousExecution(fileSnapshot, previousSnapshot)) continue;
            return new OverlappingOutputs(propertyName, fileSnapshot.getNormalizedPath());
        }
        return null;
    }

    private static boolean changedSincePreviousExecution(NormalizedFileSnapshot fileSnapshot, NormalizedFileSnapshot previousSnapshot) {
        return !previousSnapshot.getSnapshot().isContentUpToDate(fileSnapshot.getSnapshot());
    }

    private static boolean createdSincePreviousExecution(NormalizedFileSnapshot previousSnapshot) {
        return previousSnapshot == null;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getOverlappedFilePath() {
        return this.overlappedFilePath;
    }

    public String toString() {
        return String.format("output property '%s' with path '%s'", this.propertyName, this.overlappedFilePath);
    }
}

