/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultImmutableAttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableAttributes
implements AttributeContainerInternal {
    public static final ImmutableAttributes EMPTY = new ImmutableAttributes(null);
    private static final Comparator<Attribute<?>> ATTRIBUTE_NAME_COMPARATOR = new Comparator<Attribute<?>>(){

        @Override
        public int compare(Attribute<?> o1, Attribute<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    final ImmutableAttributes parent;
    final Attribute<?> attribute;
    final Object value;
    private final int hashCode;
    private final int size;
    final DefaultImmutableAttributesFactory.Builder builder;
    private Set<Attribute<?>> keySet;

    public static ImmutableAttributes of(AttributeContainer attributes) {
        return ((AttributeContainerInternal)attributes).asImmutable();
    }

    ImmutableAttributes(ImmutableAttributesFactory owner) {
        this.builder = owner != null ? owner.builder(this) : null;
        this.parent = null;
        this.attribute = null;
        this.value = null;
        this.hashCode = 0;
        this.size = 0;
    }

    ImmutableAttributes(ImmutableAttributes parent, Attribute<?> key, Object value, ImmutableAttributesFactory owner) {
        this.parent = parent;
        this.attribute = key;
        this.value = value;
        this.builder = owner != null ? owner.builder(this) : null;
        int hashCode = parent.hashCode();
        hashCode = 31 * hashCode + this.attribute.hashCode();
        this.hashCode = hashCode = 31 * hashCode + value.hashCode();
        this.size = parent.size + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAttributes that = (ImmutableAttributes)o;
        if (this.size != that.size) {
            return false;
        }
        ImmutableAttributes cur = this;
        while (cur.value != null) {
            if (!cur.value.equals(that.getAttribute(cur.attribute))) {
                return false;
            }
            cur = cur.parent;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Set<Attribute<?>> keySet() {
        if (this.parent == null) {
            return Collections.emptySet();
        }
        if (this.keySet == null) {
            this.keySet = Sets.union(Collections.singleton(this.attribute), this.parent.keySet());
        }
        return this.keySet;
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        throw new UnsupportedOperationException("Mutation of attributes is not allowed");
    }

    public <T> T getAttribute(Attribute<T> key) {
        if (key.equals(this.attribute)) {
            return (T)Cast.uncheckedCast((Object)this.value);
        }
        if (this.parent != null) {
            return this.parent.getAttribute(key);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.attribute == null;
    }

    public boolean contains(Attribute<?> key) {
        return key.equals(this.attribute) || this.parent != null && this.parent.contains(key);
    }

    @Override
    public ImmutableAttributes asImmutable() {
        return this;
    }

    @Override
    public AttributeContainerInternal copy() {
        return this;
    }

    public AttributeContainer getAttributes() {
        return this;
    }

    public String toString() {
        TreeMap sorted = new TreeMap(ATTRIBUTE_NAME_COMPARATOR);
        ImmutableAttributes node = this;
        while (node != null) {
            if (node.attribute != null) {
                sorted.put(node.attribute, node.value);
            }
            node = node.parent;
        }
        return ((Object)sorted).toString();
    }
}

