/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskClassInfo;
import org.gradle.api.internal.project.taskfactory.TaskClassInfoStore;
import org.gradle.api.internal.project.taskfactory.TaskClassValidator;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessingTaskFactory
implements ITaskFactory {
    private final TaskClassInfoStore taskClassInfoStore;
    private final ITaskFactory taskFactory;

    public AnnotationProcessingTaskFactory(TaskClassInfoStore taskClassInfoStore, ITaskFactory taskFactory) {
        this.taskClassInfoStore = taskClassInfoStore;
        this.taskFactory = taskFactory;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new AnnotationProcessingTaskFactory(this.taskClassInfoStore, this.taskFactory.createChild(project, instantiator));
    }

    @Override
    public TaskInternal createTask(Map<String, ?> args) {
        return this.process(this.taskFactory.createTask(args));
    }

    public <S extends TaskInternal> S create(String name, Class<S> type) {
        return (S)this.process((TaskInternal)this.taskFactory.create(name, type));
    }

    private <S extends TaskInternal> S process(S task) {
        TaskClassInfo taskClassInfo = this.taskClassInfoStore.getTaskClassInfo(task.getClass());
        if (taskClassInfo.isIncremental()) {
            task.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task element) {
                    return true;
                }
            });
        }
        for (Factory<Action<Task>> actionFactory : taskClassInfo.getTaskActions()) {
            task.prependParallelSafeAction((Action<Task>)((Action)actionFactory.create()));
        }
        TaskClassValidator validator = taskClassInfo.getValidator();
        if (validator.hasAnythingToValidate()) {
            task.prependParallelSafeAction(validator);
            validator.addInputsAndOutputs(task);
        }
        if (taskClassInfo.isCacheable()) {
            task.getOutputs().cacheIf("Annotated with @CacheableTask", Specs.SATISFIES_ALL);
        }
        return task;
    }
}

