/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.CompatibilityCheckResult;
import org.gradle.api.internal.attributes.CompatibilityRule;
import org.gradle.api.internal.attributes.DefaultAttributeMatchingStrategy;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.component.model.ComponentAttributeMatcher;
import org.gradle.internal.component.model.DefaultCompatibilityCheckResult;

public class DefaultAttributesSchema
implements AttributesSchemaInternal,
AttributesSchema {
    private final ComponentAttributeMatcher componentAttributeMatcher;
    private final InstantiatorFactory instantiatorFactory;
    private final Map<Attribute<?>, AttributeMatchingStrategy<?>> strategies = Maps.newHashMap();
    private final DefaultAttributeMatcher matcher;

    public DefaultAttributesSchema(ComponentAttributeMatcher componentAttributeMatcher, InstantiatorFactory instantiatorFactory) {
        this.componentAttributeMatcher = componentAttributeMatcher;
        this.instantiatorFactory = instantiatorFactory;
        this.matcher = new DefaultAttributeMatcher(componentAttributeMatcher, this.mergeWith(EmptySchema.INSTANCE));
    }

    public <T> AttributeMatchingStrategy<T> getMatchingStrategy(Attribute<T> attribute) {
        AttributeMatchingStrategy<?> strategy = this.strategies.get(attribute);
        if (strategy == null) {
            throw new IllegalArgumentException("Unable to find matching strategy for " + attribute);
        }
        return (AttributeMatchingStrategy)Cast.uncheckedCast(strategy);
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute) {
        return this.attribute(attribute, null);
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute, Action<? super AttributeMatchingStrategy<T>> configureAction) {
        AttributeMatchingStrategy strategy = (AttributeMatchingStrategy)Cast.uncheckedCast(this.strategies.get(attribute));
        if (strategy == null) {
            strategy = (AttributeMatchingStrategy)Cast.uncheckedCast((Object)this.instantiatorFactory.decorate().newInstance(DefaultAttributeMatchingStrategy.class, new Object[]{this.instantiatorFactory}));
            this.strategies.put(attribute, strategy);
        }
        if (configureAction != null) {
            configureAction.execute((Object)strategy);
        }
        return strategy;
    }

    public Set<Attribute<?>> getAttributes() {
        return this.strategies.keySet();
    }

    public boolean hasAttribute(Attribute<?> key) {
        return this.strategies.containsKey(key);
    }

    AttributeSelectionSchema mergeWith(AttributesSchemaInternal producerSchema) {
        return new MergedSchema(producerSchema);
    }

    @Override
    public AttributeMatcher withProducer(AttributesSchemaInternal producerSchema) {
        return new DefaultAttributeMatcher(this.componentAttributeMatcher, this.mergeWith(producerSchema));
    }

    @Override
    public AttributeMatcher matcher() {
        return this.matcher;
    }

    @Override
    public CompatibilityRule<Object> compatibilityRules(Attribute<?> attribute) {
        AttributeMatchingStrategy<?> matchingStrategy = this.strategies.get(attribute);
        if (matchingStrategy != null) {
            return (CompatibilityRule)Cast.uncheckedCast((Object)matchingStrategy.getCompatibilityRules());
        }
        return EmptySchema.INSTANCE.compatibilityRules(attribute);
    }

    @Override
    public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
        AttributeMatchingStrategy<?> matchingStrategy = this.strategies.get(attribute);
        if (matchingStrategy != null) {
            return (DisambiguationRule)Cast.uncheckedCast((Object)matchingStrategy.getDisambiguationRules());
        }
        return EmptySchema.INSTANCE.disambiguationRules(attribute);
    }

    private class MergedSchema
    implements AttributeSelectionSchema {
        private final AttributesSchemaInternal producerSchema;

        MergedSchema(AttributesSchemaInternal producerSchema) {
            this.producerSchema = producerSchema;
        }

        @Override
        public boolean hasAttribute(Attribute<?> attribute) {
            return DefaultAttributesSchema.this.getAttributes().contains(attribute) || this.producerSchema.getAttributes().contains(attribute);
        }

        @Override
        public void disambiguate(Attribute<?> attribute, MultipleCandidatesResult<Object> result) {
            DisambiguationRule<Object> rules = DefaultAttributesSchema.this.disambiguationRules(attribute);
            rules.execute(result);
            if (result.hasResult()) {
                return;
            }
            rules = this.producerSchema.disambiguationRules(attribute);
            rules.execute(result);
            if (result.hasResult()) {
                return;
            }
            Object requested = result.getConsumerValue();
            if (requested != null && result.getCandidateValues().contains(requested)) {
                result.closestMatch(requested);
                return;
            }
            for (Object candidate : result.getCandidateValues()) {
                result.closestMatch(candidate);
            }
        }

        @Override
        public void matchValue(Attribute<?> attribute, CompatibilityCheckResult<Object> result) {
            if (result.getConsumerValue().equals(result.getProducerValue())) {
                result.compatible();
                return;
            }
            CompatibilityRule<Object> rules = DefaultAttributesSchema.this.compatibilityRules(attribute);
            rules.execute(result);
            if (result.hasResult()) {
                return;
            }
            rules = this.producerSchema.compatibilityRules(attribute);
            rules.execute(result);
            if (result.hasResult()) {
                return;
            }
            result.incompatible();
        }
    }

    private static class DefaultAttributeMatcher
    implements AttributeMatcher {
        private final ComponentAttributeMatcher componentAttributeMatcher;
        private final AttributeSelectionSchema effectiveSchema;

        DefaultAttributeMatcher(ComponentAttributeMatcher componentAttributeMatcher, AttributeSelectionSchema effectiveSchema) {
            this.componentAttributeMatcher = componentAttributeMatcher;
            this.effectiveSchema = effectiveSchema;
        }

        @Override
        public boolean isMatching(AttributeContainer candidate, AttributeContainer requested) {
            return this.componentAttributeMatcher.isMatching(this.effectiveSchema, candidate, requested);
        }

        @Override
        public <T> boolean isMatching(Attribute<T> attribute, T candidate, T requested) {
            DefaultCompatibilityCheckResult<Object> result = new DefaultCompatibilityCheckResult<Object>(requested, candidate);
            this.effectiveSchema.matchValue(attribute, result);
            return result.isCompatible();
        }

        @Override
        public <T extends HasAttributes> List<T> matches(Collection<? extends T> candidates, AttributeContainerInternal requested) {
            return this.matches(candidates, requested, null);
        }

        @Override
        public <T extends HasAttributes> List<T> matches(Collection<? extends T> candidates, AttributeContainerInternal requested, @Nullable T fallback) {
            return this.componentAttributeMatcher.match(this.effectiveSchema, candidates, (AttributeContainer)requested, fallback);
        }
    }
}

