/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.internal.DynamicObjectUtil;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.util.CollectionUtils;

public class SourceFoldersCreator {
    public List<ClasspathEntry> createSourceFolders(final EclipseClasspath classpath) {
        ArrayList entries = Lists.newArrayList();
        Function<File, String> provideRelativePath = new Function<File, String>(){

            public String apply(File input) {
                return classpath.getProject().relativePath((Object)input);
            }
        };
        List<SourceFolder> regulars = this.getRegularSourceFolders(classpath.getSourceSets(), provideRelativePath);
        List<SourceFolder> trimmedExternals = this.getExternalSourceFolders(classpath.getSourceSets(), provideRelativePath);
        entries.addAll(regulars);
        entries.addAll(trimmedExternals);
        return entries;
    }

    public List<SourceFolder> getRegularSourceFolders(Iterable<SourceSet> sourceSets, Function<File, String> provideRelativePath) {
        List<SourceFolder> sourceFolders = this.projectRelativeFolders(sourceSets, provideRelativePath);
        return CollectionUtils.filter(sourceFolders, (Spec)new Spec<SourceFolder>(){

            public boolean isSatisfiedBy(SourceFolder element) {
                return !element.getPath().contains("..");
            }
        });
    }

    public List<SourceFolder> getExternalSourceFolders(Iterable<SourceSet> sourceSets, Function<File, String> provideRelativePath) {
        List<SourceFolder> sourceFolders = this.projectRelativeFolders(sourceSets, provideRelativePath);
        List externalSourceFolders = CollectionUtils.filter(sourceFolders, (Spec)new Spec<SourceFolder>(){

            public boolean isSatisfiedBy(SourceFolder element) {
                return element.getPath().contains("..");
            }
        });
        List<SourceFolder> regularSourceFolders = this.getRegularSourceFolders(sourceSets, provideRelativePath);
        ArrayList sources = Lists.newArrayList((Iterable)Lists.transform(regularSourceFolders, (Function)new Function<SourceFolder, String>(){

            public String apply(SourceFolder sourceFolder) {
                return sourceFolder.getName();
            }
        }));
        return this.trimAndDedup(externalSourceFolders, sources);
    }

    private List<SourceFolder> trimAndDedup(List<SourceFolder> externalSourceFolders, List<String> givenSources) {
        ArrayList trimmedSourceFolders = Lists.newArrayList();
        for (SourceFolder folder : externalSourceFolders) {
            folder.trim();
            for (File parentFile = folder.getDir().getParentFile(); givenSources.contains(folder.getName()) && parentFile != null; parentFile = parentFile.getParentFile()) {
                folder.trim(parentFile.getName());
            }
            givenSources.add(folder.getName());
            trimmedSourceFolders.add(folder);
        }
        return trimmedSourceFolders;
    }

    private List<SourceFolder> projectRelativeFolders(Iterable<SourceSet> sourceSets, Function<File, String> provideRelativePath) {
        ArrayList entries = Lists.newArrayList();
        List<SourceSet> sortedSourceSets = this.sortSourceSetsAsPerUsualConvention(sourceSets);
        for (SourceSet sourceSet : sortedSourceSets) {
            List<DirectoryTree> sortedSourceDirs = this.sortSourceDirsAsPerUsualConvention(sourceSet.getAllSource().getSrcDirTrees());
            for (DirectoryTree tree : sortedSourceDirs) {
                File dir = tree.getDir();
                if (!dir.isDirectory()) continue;
                String relativePath = (String)provideRelativePath.apply((Object)dir);
                SourceFolder folder = new SourceFolder(relativePath, null);
                folder.setDir(dir);
                folder.setName(dir.getName());
                folder.setIncludes(this.getIncludesForTree(sourceSet, tree));
                folder.setExcludes(this.getExcludesForTree(sourceSet, tree));
                entries.add(folder);
            }
        }
        return entries;
    }

    private List<String> getExcludesForTree(SourceSet sourceSet, DirectoryTree directoryTree) {
        List<Set<String>> excludesByType = this.getFiltersForTreeGroupedByType(sourceSet, directoryTree, "excludes");
        return CollectionUtils.intersection(excludesByType);
    }

    private List<String> getIncludesForTree(SourceSet sourceSet, DirectoryTree directoryTree) {
        List<Set<String>> includesByType = this.getFiltersForTreeGroupedByType(sourceSet, directoryTree, "includes");
        for (Set<String> it : includesByType) {
            if (!it.isEmpty()) continue;
            return Collections.emptyList();
        }
        List allIncludes = CollectionUtils.flattenCollections(String.class, (Object[])new Object[]{includesByType});
        return ImmutableSet.copyOf((Collection)allIncludes).asList();
    }

    private List<Set<String>> getFiltersForTreeGroupedByType(SourceSet sourceSet, DirectoryTree directoryTree, String filterOperation) {
        Set javaSrcDirs = sourceSet.getAllJava().getSrcDirs();
        Set resSrcDirs = sourceSet.getResources().getSrcDirs();
        List srcDirs = CollectionUtils.intersection((Collection)Lists.newArrayList((Object[])new Set[]{javaSrcDirs, resSrcDirs}));
        if (!srcDirs.contains(directoryTree.getDir())) {
            return Lists.newArrayList((Object[])new Set[]{this.collectFilters(directoryTree.getPatterns(), filterOperation)});
        }
        Set<String> resourcesFilter = this.collectFilters(sourceSet.getResources().getSrcDirTrees(), directoryTree.getDir(), filterOperation);
        Set<String> sourceFilter = this.collectFilters(sourceSet.getAllJava().getSrcDirTrees(), directoryTree.getDir(), filterOperation);
        return Lists.newArrayList((Object[])new Set[]{resourcesFilter, sourceFilter});
    }

    private Set<String> collectFilters(Set<DirectoryTree> directoryTrees, File targetDir, String filterOperation) {
        for (DirectoryTree directoryTree : directoryTrees) {
            if (!directoryTree.getDir().equals(targetDir)) continue;
            PatternSet patterns = directoryTree.getPatterns();
            return this.collectFilters(patterns, filterOperation);
        }
        return Collections.emptySet();
    }

    private Set<String> collectFilters(PatternSet patterns, String filterOperation) {
        return (Set)Cast.uncheckedCast((Object)DynamicObjectUtil.asDynamicObject((Object)patterns).getProperty(filterOperation));
    }

    private List<SourceSet> sortSourceSetsAsPerUsualConvention(Iterable<SourceSet> sourceSets) {
        return CollectionUtils.sort(sourceSets, (Comparator)new Comparator<SourceSet>(){

            @Override
            public int compare(SourceSet left, SourceSet right) {
                return SourceFoldersCreator.toComparable(left).compareTo(SourceFoldersCreator.toComparable(right));
            }
        });
    }

    private List<DirectoryTree> sortSourceDirsAsPerUsualConvention(Iterable<DirectoryTree> sourceDirs) {
        return CollectionUtils.sort(sourceDirs, (Comparator)new Comparator<DirectoryTree>(){

            @Override
            public int compare(DirectoryTree left, DirectoryTree right) {
                return SourceFoldersCreator.toComparable(left).compareTo(SourceFoldersCreator.toComparable(right));
            }
        });
    }

    private static Comparable toComparable(SourceSet sourceSet) {
        String name = sourceSet.getName();
        if ("main".equals(name)) {
            return Integer.valueOf(0);
        }
        if ("test".equals(name)) {
            return Integer.valueOf(1);
        }
        return Integer.valueOf(2);
    }

    private static Comparable toComparable(DirectoryTree tree) {
        String path = tree.getDir().getPath();
        if (path.endsWith("java")) {
            return Integer.valueOf(0);
        }
        if (path.endsWith("resources")) {
            return Integer.valueOf(2);
        }
        return Integer.valueOf(1);
    }
}

