/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileVar;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.nativeplatform.test.xctest.internal.SwiftStdlibToolLocator;
import org.gradle.process.ExecSpec;

@Incubating
public class CreateXcTestBundle
extends DefaultTask {
    private final RegularFileVar informationFile = this.newInputFile();
    private final RegularFileVar executableFile = this.newInputFile();
    private final DirectoryVar outputDir = this.newOutputDirectory();
    private final SwiftStdlibToolLocator swiftStdlibToolLocator;

    @Inject
    public CreateXcTestBundle(SwiftStdlibToolLocator swiftStdlibToolLocator) {
        this.swiftStdlibToolLocator = swiftStdlibToolLocator;
    }

    @TaskAction
    void createBundle() {
        this.getProject().copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from((Object)CreateXcTestBundle.this.getExecutableFile(), (Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.into((Object)"Contents/MacOS");
                    }
                });
                copySpec.from((Object)CreateXcTestBundle.this.getInformationFile(), (Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.into((Object)"Contents");
                    }
                });
                copySpec.into((Object)CreateXcTestBundle.this.getOutputDir());
            }
        });
        this.getProject().exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.executable((Object)CreateXcTestBundle.this.swiftStdlibToolLocator.find());
                execSpec.args(new Object[]{"--copy", "--scan-executable", CreateXcTestBundle.this.getExecutableFile().getAbsolutePath(), "--destination", ((Directory)CreateXcTestBundle.this.outputDir.dir("Contents/Frameworks").get()).getAsFile().getAbsolutePath(), "--platform", "macosx", "--resource-destination", ((Directory)CreateXcTestBundle.this.outputDir.dir("Contents/Resources").get()).getAsFile().getAbsolutePath(), "--scan-folder", ((Directory)CreateXcTestBundle.this.outputDir.dir("Contents/Frameworks").get()).getAsFile().getAbsolutePath()});
            }
        }).assertNormalExitValue();
    }

    @OutputDirectory
    public File getOutputDir() {
        return (File)this.outputDir.getAsFile().getOrNull();
    }

    public void setOutputDir(File outputDir) {
        this.outputDir.set(outputDir);
    }

    public void setOutputDir(Provider<? extends Directory> outputDir) {
        this.outputDir.set(outputDir);
    }

    @InputFile
    public File getExecutableFile() {
        return (File)this.executableFile.getAsFile().getOrNull();
    }

    public void setExecutableFile(File executableFile) {
        this.executableFile.set(executableFile);
    }

    public void setExecutableFile(Provider<? extends RegularFile> executableFile) {
        this.executableFile.set(executableFile);
    }

    @InputFile
    public File getInformationFile() {
        return (File)this.informationFile.getAsFile().getOrNull();
    }

    public void setInformationFile(File informationFile) {
        this.informationFile.set(informationFile);
    }

    public void setInformationFile(Provider<? extends RegularFile> informationFile) {
        this.informationFile.set(informationFile);
    }
}

