/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashUtil;

public class NativeDependencyCache
implements Stoppable {
    private final PersistentCache cache;
    private final FileHasher fileHasher;

    public NativeDependencyCache(CacheRepository cacheRepository, FileHasher fileHasher) {
        this.cache = cacheRepository.cache("native-dep").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
        this.fileHasher = fileHasher;
    }

    public File getUnpackedHeaders(final File headersZip, final String baseName) {
        final String hash = HashUtil.compactStringFor((HashCode)this.fileHasher.hash(headersZip));
        return (File)this.cache.useCache((Factory)new Factory<File>(){

            public File create() {
                File dir = new File(NativeDependencyCache.this.cache.getBaseDir(), hash + "/" + baseName);
                if (dir.isDirectory()) {
                    return dir;
                }
                try {
                    NativeDependencyCache.this.unzipTo(headersZip, dir);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not unzip headers from " + headersZip, (Throwable)e);
                }
                return dir;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipTo(File headersZip, File unzipDir) throws IOException {
        try (ZipInputStream inputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(headersZip)));){
            ZipEntry entry = null;
            while ((entry = inputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File outFile = new File(unzipDir, entry.getName());
                Files.createParentDirs((File)outFile);
                try (FileOutputStream outputStream = new FileOutputStream(outFile);){
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
        }
    }

    public File getBinary(final File file, final String binaryName) {
        final HashCode hash = this.fileHasher.hash(file);
        return (File)this.cache.useCache((Factory)new Factory<File>(){

            public File create() {
                File binaryFile = new File(NativeDependencyCache.this.cache.getBaseDir(), hash + "/" + binaryName);
                if (binaryFile.isFile()) {
                    return binaryFile;
                }
                try {
                    Files.createParentDirs((File)binaryFile);
                    Files.copy((File)file, (File)binaryFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not copy binary file " + file, (Throwable)e);
                }
                return binaryFile;
            }
        });
    }

    public void stop() {
        this.cache.close();
    }
}

