/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.language.nativeplatform.internal.incremental.HeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultHeaderDependenciesCollector
implements HeaderDependenciesCollector {
    private final Logger logger = LoggerFactory.getLogger(DefaultHeaderDependenciesCollector.class);
    private final DirectoryFileTreeFactory directoryFileTreeFactory;

    public DefaultHeaderDependenciesCollector(DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.directoryFileTreeFactory = directoryFileTreeFactory;
    }

    @Override
    public ImmutableSortedSet<File> collectHeaderDependencies(String taskName, List<File> includeRoots, IncrementalCompilation incrementalCompilation) {
        final HashSet<File> headerDependencies = new HashSet<File>();
        headerDependencies.addAll(incrementalCompilation.getDiscoveredInputs());
        if (incrementalCompilation.isMacroIncludeUsedInSources()) {
            this.logger.info("After parsing the source files, Gradle cannot calculate the exact set of include files for {}. Every file in the include search path will be considered a header dependency.", (Object)taskName);
            for (File includeRoot : includeRoots) {
                this.logger.info("adding files in {} to header dependencies for {}", (Object)includeRoot, (Object)taskName);
                this.directoryFileTreeFactory.create(includeRoot).visit((FileVisitor)new EmptyFileVisitor(){

                    public void visitFile(FileVisitDetails fileDetails) {
                        headerDependencies.add(fileDetails.getFile());
                    }
                });
            }
        }
        return ImmutableSortedSet.copyOf(headerDependencies);
    }
}

