/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.DefaultIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;

public class DefaultMutableIvyModuleResolveMetadata
extends AbstractMutableModuleComponentResolveMetadata
implements MutableIvyModuleResolveMetadata {
    private final ImmutableList<Artifact> artifacts;
    private final ImmutableMap<String, Configuration> configurations;
    private ImmutableList<Exclude> excludes;
    private ImmutableMap<NamespaceId, String> extraAttributes;
    private String branch;

    public static DefaultMutableIvyModuleResolveMetadata missing(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier) {
        DefaultMutableIvyModuleResolveMetadata metadata = new DefaultMutableIvyModuleResolveMetadata(id, componentIdentifier);
        metadata.setMissing(true);
        return metadata;
    }

    public DefaultMutableIvyModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier) {
        this(id, componentIdentifier, (Collection<Configuration>)ImmutableList.of((Object)new Configuration("default", true, true, (Collection<String>)ImmutableSet.of())), (Collection<? extends DependencyMetadata>)ImmutableList.of(), (Collection<? extends Artifact>)ImmutableList.of((Object)new Artifact(new DefaultIvyArtifactName(componentIdentifier.getModule(), "jar", "jar"), (Set<String>)ImmutableSet.of((Object)"default"))));
    }

    public DefaultMutableIvyModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier, Collection<Configuration> configurations, Collection<? extends DependencyMetadata> dependencies, Collection<? extends Artifact> artifacts) {
        super(id, componentIdentifier, (List<? extends DependencyMetadata>)ImmutableList.copyOf(dependencies));
        this.configurations = DefaultMutableIvyModuleResolveMetadata.toMap(configurations);
        this.artifacts = ImmutableList.copyOf(artifacts);
        this.excludes = ImmutableList.of();
        this.extraAttributes = ImmutableMap.of();
    }

    public DefaultMutableIvyModuleResolveMetadata(IvyModuleResolveMetadata metadata) {
        super(metadata);
        this.configurations = metadata.getConfigurationDefinitions();
        this.artifacts = metadata.getArtifactDefinitions();
        this.excludes = metadata.getExcludes();
        this.branch = metadata.getBranch();
        this.extraAttributes = metadata.getExtraAttributes();
    }

    private static ImmutableMap<String, Configuration> toMap(Collection<Configuration> configurations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Configuration configuration : configurations) {
            builder.put((Object)configuration.getName(), (Object)configuration);
        }
        return builder.build();
    }

    @Override
    public ImmutableMap<String, Configuration> getConfigurationDefinitions() {
        return this.configurations;
    }

    @Override
    public ImmutableList<Artifact> getArtifactDefinitions() {
        return this.artifacts;
    }

    @Override
    public ImmutableList<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public void setExcludes(Iterable<? extends Exclude> excludes) {
        this.excludes = ImmutableList.copyOf(excludes);
    }

    @Override
    public ImmutableMap<NamespaceId, String> getExtraAttributes() {
        return this.extraAttributes;
    }

    @Override
    public void setExtraAttributes(Map<NamespaceId, String> extraAttributes) {
        this.extraAttributes = ImmutableMap.copyOf(extraAttributes);
    }

    @Override
    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public IvyModuleResolveMetadata asImmutable() {
        return new DefaultIvyModuleResolveMetadata(this);
    }
}

