/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyState<T>
implements PropertyInternal<T> {
    private final Class<T> type;
    private Provider<? extends T> provider = Providers.notDefined();

    public DefaultPropertyState(Class<T> type) {
        this.type = type;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            this.set(object);
        }
    }

    public void set(T value) {
        if (value == null) {
            this.provider = Providers.notDefined();
            return;
        }
        if (!this.type.isInstance(value)) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.type.getName(), value.getClass().getName()));
        }
        this.provider = Providers.of(value);
    }

    protected Provider<? extends T> getProvider() {
        return this.provider;
    }

    public void set(Provider<? extends T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal p = (ProviderInternal)Cast.uncheckedCast(provider);
        if (p.getType() != null && !this.type.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.type.getName(), p.getType().getName()));
        }
        if (p.getType() == null) {
            p = p.map(new Transformer<T, T>(){

                public T transform(T t) {
                    if (DefaultPropertyState.this.type.isInstance(t)) {
                        return t;
                    }
                    throw new IllegalArgumentException(String.format("Cannot get the value of a property of type %s as the provider associated with this property returned a value of type %s.", DefaultPropertyState.this.type.getName(), t.getClass().getName()));
                }
            });
        }
        this.provider = p;
    }

    public T get() {
        return (T)this.provider.get();
    }

    public T getOrNull() {
        return (T)this.provider.getOrNull();
    }

    public T getOrElse(T defaultValue) {
        Object t = this.provider.getOrNull();
        if (t == null) {
            return defaultValue;
        }
        return (T)t;
    }

    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
        return new TransformBackedProvider<S, T>(transformer, this);
    }

    public boolean isPresent() {
        return this.provider.isPresent();
    }

    public String toString() {
        return String.format("value: %s", this.getOrNull());
    }
}

