/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.state.InputPathNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.PathNormalizationStrategy;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.DeclaredTaskInputFileProperty;
import org.gradle.api.internal.tasks.GenericFileNormalizer;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputsDeprecationSupport;
import org.gradle.api.internal.tasks.TaskPropertyFileCollection;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskInputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskInputFilePropertySpec
extends TaskInputsDeprecationSupport
implements DeclaredTaskInputFileProperty {
    private final ValidatingValue value;
    private final ValidationAction validationAction;
    private final TaskPropertyFileCollection files;
    private String propertyName;
    private boolean skipWhenEmpty;
    private boolean optional;
    private PathNormalizationStrategy pathNormalizationStrategy = InputPathNormalizationStrategy.ABSOLUTE;
    private Class<? extends FileNormalizer> normalizer = GenericFileNormalizer.class;

    public DefaultTaskInputFilePropertySpec(String taskName, FileResolver resolver, ValidatingValue paths, ValidationAction validationAction) {
        this.value = paths;
        this.validationAction = validationAction;
        this.files = new TaskPropertyFileCollection(taskName, "input", this, resolver, paths);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public FileCollection getPropertyFiles() {
        return this.files;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPropertyName(String propertyName) {
        this.propertyName = TaskPropertyUtils.checkPropertyName(propertyName);
        return this;
    }

    @Override
    public boolean isSkipWhenEmpty() {
        return this.skipWhenEmpty;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty(boolean skipWhenEmpty) {
        this.skipWhenEmpty = skipWhenEmpty;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty() {
        return this.skipWhenEmpty(true);
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional() {
        return this.optional(true);
    }

    @Override
    public PathNormalizationStrategy getPathNormalizationStrategy() {
        return this.pathNormalizationStrategy;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPathSensitivity(PathSensitivity sensitivity) {
        return this.withPathNormalizationStrategy(InputPathNormalizationStrategy.valueOf(sensitivity));
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPathNormalizationStrategy(PathNormalizationStrategy pathNormalizationStrategy) {
        this.pathNormalizationStrategy = pathNormalizationStrategy;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withNormalizer(Class<? extends FileNormalizer> normalizer) {
        this.normalizer = normalizer;
        return this;
    }

    @Override
    public Class<? extends FileNormalizer> getNormalizer() {
        return this.normalizer;
    }

    @Override
    public void validate(TaskValidationContext context) {
        this.value.validate(this.getPropertyName(), this.optional, this.validationAction, context);
    }

    @Override
    protected TaskInputs getTaskInputs(String method) {
        throw new UnsupportedOperationException(String.format("Chaining of the TaskInputs.%s method is not supported since Gradle 4.0.", method));
    }

    public String toString() {
        return this.getPropertyName() + " (" + this.pathNormalizationStrategy + ")";
    }

    @Override
    public int compareTo(TaskPropertySpec o) {
        return this.getPropertyName().compareTo(o.getPropertyName());
    }
}

