/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.CachedSingletonsRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    private static ProgressManager ourInstance = CachedSingletonsRegistry.markCachedField(ProgressManager.class);

    @NotNull
    public static ProgressManager getInstance() {
        ProgressManager result2 = ourInstance;
        if (result2 == null) {
            ourInstance = result2 = ServiceManager.getService(ProgressManager.class);
        }
        ProgressManager progressManager = result2;
        if (progressManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/ProgressManager", "getInstance"));
        }
        return progressManager;
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return null;
    }

    public abstract void executeNonCancelableSection(@NotNull Runnable var1);

    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/ProgressManager", "indicatorCanceled"));
        }
    }

    public static void canceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/ProgressManager", "canceled"));
        }
        ProgressManager.getInstance().indicatorCanceled(indicator);
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager instance = ourInstance;
        if (instance != null) {
            instance.doCheckCanceled();
        }
    }

    public abstract void executeProcessUnderProgress(@NotNull Runnable var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;
}

