/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import org.jetbrains.kotlin.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceJavaCodeReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionBase;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.DelegatingScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.NullableFunction;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class PsiReferenceExpressionImpl
extends PsiReferenceExpressionBase
implements PsiReferenceExpression,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl");
    private volatile String myCachedQName;
    private volatile String myCachedNormalizedText;
    private static final Function<PsiReferenceExpressionImpl, PsiType> TYPE_EVALUATOR = new TypeEvaluator();

    public PsiReferenceExpressionImpl() {
        super(JavaElementType.REFERENCE_EXPRESSION);
    }

    @Override
    public PsiExpression getQualifierExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) throws IncorrectOperationException {
        boolean doImportStatic;
        if (qualifierClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "bindToElementViaStaticImport"));
        }
        String qualifiedName2 = qualifierClass.getQualifiedName();
        if (qualifiedName2 == null) {
            throw new IncorrectOperationException();
        }
        if (this.getQualifierExpression() != null) {
            throw new IncorrectOperationException("Reference is qualified: " + this.getText());
        }
        if (!this.isPhysical()) {
            return this;
        }
        String staticName = this.getReferenceName();
        PsiFile containingFile = this.getContainingFile();
        PsiImportList importList = null;
        if (containingFile instanceof PsiJavaFile) {
            String qName;
            importList = ((PsiJavaFile)containingFile).getImportList();
            assert (importList != null) : containingFile;
            PsiImportStatementBase singleImportStatement = importList.findSingleImportStatement(staticName);
            boolean bl = doImportStatic = singleImportStatement == null;
            if (singleImportStatement instanceof PsiImportStaticStatement && (qName = qualifierClass.getQualifiedName() + "." + staticName).equals(singleImportStatement.getImportReference().getQualifiedName())) {
                return this;
            }
        } else {
            doImportStatic = false;
        }
        if (doImportStatic) {
            PsiReferenceExpressionImpl.bindToElementViaStaticImport(qualifierClass, staticName, importList);
        } else {
            PsiManager manager = this.getManager();
            PsiReferenceExpression classRef = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createReferenceExpression(qualifierClass);
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, treeCharTab, manager);
            this.addInternal(dot, dot, SourceTreeToPsiMap.psiElementToTree(this.getParameterList()), Boolean.TRUE);
            this.addBefore(classRef, SourceTreeToPsiMap.treeElementToPsi(dot));
        }
        return this;
    }

    public static void bindToElementViaStaticImport(PsiClass qualifierClass, String staticName, PsiImportList importList) throws IncorrectOperationException {
        assert (importList != null);
        String qualifiedName2 = qualifierClass.getQualifiedName();
        List<PsiJavaCodeReferenceElement> refs = PsiReferenceExpressionImpl.getImportsFromClass(importList, qualifiedName2);
        if (refs.size() < JavaCodeStyleSettingsFacade.getInstance(qualifierClass.getProject()).getNamesCountToUseImportOnDemand() || JavaCodeStyleManager.getInstance(qualifierClass.getProject()).hasConflictingOnDemandImport((PsiJavaFile)importList.getContainingFile(), qualifierClass, staticName)) {
            importList.add(JavaPsiFacade.getInstance(qualifierClass.getProject()).getElementFactory().createImportStaticStatement(qualifierClass, staticName));
        } else {
            for (PsiJavaCodeReferenceElement ref : refs) {
                PsiImportStaticStatement importStatement = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStaticStatement.class);
                if (importStatement == null) continue;
                importStatement.delete();
            }
            importList.add(JavaPsiFacade.getInstance(qualifierClass.getProject()).getElementFactory().createImportStaticStatement(qualifierClass, "*"));
        }
    }

    private static List<PsiJavaCodeReferenceElement> getImportsFromClass(@NotNull PsiImportList importList, String className2) {
        if (importList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importList", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "getImportsFromClass"));
        }
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !Comparing.strEqual(psiClass.getQualifiedName(), className2)) continue;
            array.add(staticStatement.getImportReference());
        }
        return array;
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        PsiExpression oldQualifier = this.getQualifierExpression();
        if (newQualifier == null) {
            if (oldQualifier != null) {
                this.deleteChildInternal(oldQualifier.getNode());
            }
        } else if (oldQualifier != null) {
            oldQualifier.replace(newQualifier);
        } else {
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            TreeElement dot = (TreeElement)this.findChildByRole(55);
            if (dot == null) {
                dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, treeCharTab, this.getManager());
                dot = this.addInternal(dot, dot, this.getFirstChildNode(), Boolean.TRUE);
            }
            this.addBefore(newQualifier, dot.getPsi());
        }
    }

    @Override
    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    public void clearCaches() {
        this.myCachedQName = null;
        this.myCachedNormalizedText = null;
        super.clearCaches();
    }

    @NotNull
    private JavaResolveResult[] resolve(IElementType parentType, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolve"));
        }
        if (parentType == JavaElementType.REFERENCE_EXPRESSION) {
            PsiElement classNameElement;
            JavaResolveResult[] variable2 = null;
            JavaResolveResult[] result2 = this.resolveToVariable(containingFile);
            if (result2.length == 1) {
                if (result2[0].isAccessible()) {
                    if (result2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolve"));
                    }
                    return result2;
                }
                variable2 = result2;
            }
            if (!((classNameElement = this.getReferenceNameElement()) instanceof PsiIdentifier)) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolve"));
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            result2 = this.resolveToClass(classNameElement, containingFile);
            if (result2.length == 1 && !result2[0].isAccessible()) {
                JavaResolveResult[] packageResult = this.resolveToPackage(containingFile);
                if (packageResult.length != 0) {
                    result2 = packageResult;
                }
            } else if (result2.length == 0) {
                result2 = this.resolveToPackage(containingFile);
            }
            JavaResolveResult[] javaResolveResultArray = result2.length == 0 && variable2 != null ? variable2 : result2;
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolve"));
            }
            return javaResolveResultArray;
        }
        if (parentType == JavaElementType.METHOD_CALL_EXPRESSION) {
            JavaResolveResult[] javaResolveResultArray = this.resolveToMethod(containingFile);
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolve"));
            }
            return javaResolveResultArray;
        }
        if (parentType == JavaElementType.METHOD_REF_EXPRESSION) {
            if (((PsiMethodReferenceExpression)this.getParent()).isConstructor()) {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (classNameElement == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                JavaResolveResult[] javaResolveResultArray = this.resolveToClass(classNameElement, containingFile);
                if (javaResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolve"));
                }
                return javaResolveResultArray;
            }
            JavaResolveResult[] javaResolveResultArray = this.resolve(JavaElementType.REFERENCE_EXPRESSION, containingFile);
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolve"));
            }
            return javaResolveResultArray;
        }
        JavaResolveResult[] javaResolveResultArray = this.resolveToVariable(containingFile);
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolve"));
        }
        return javaResolveResultArray;
    }

    @NotNull
    private JavaResolveResult[] resolveToMethod(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToMethod"));
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)this.getParent();
        MethodResolverProcessor processor = new MethodResolverProcessor(methodCall, containingFile);
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
        }
        catch (MethodProcessorSetupFailedException e) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToMethod"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToMethod"));
        }
        return javaResolveResultArray;
    }

    @NotNull
    private JavaResolveResult[] resolveToPackage(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToPackage"));
        }
        String packageName = this.getCachedNormalizedText();
        Project project = containingFile.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiPackage aPackage = psiFacade.findPackage(packageName);
        if (aPackage == null) {
            JavaResolveResult[] javaResolveResultArray = psiFacade.isPartOfPackagePrefix(packageName) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToPackage"));
            }
            return javaResolveResultArray;
        }
        PsiExpression qualifier = this.getQualifierExpression();
        if (qualifier instanceof PsiReferenceExpression && !(((PsiReferenceExpression)qualifier).resolve() instanceof PsiPackage)) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToPackage"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo(aPackage, PsiSubstitutor.EMPTY)};
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToPackage"));
        }
        return javaResolveResultArray;
    }

    @NotNull
    private JavaResolveResult[] resolveToClass(@NotNull PsiElement classNameElement, @NotNull PsiFile containingFile) {
        if (classNameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classNameElement", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToClass"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToClass"));
        }
        String className2 = classNameElement.getText();
        ClassResolverProcessor processor = new ClassResolverProcessor(className2, this, containingFile);
        PsiScopesUtil.resolveAndWalk(processor, this, null);
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToClass"));
        }
        return javaResolveResultArray;
    }

    @NotNull
    private JavaResolveResult[] resolveToVariable(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToVariable"));
        }
        VariableResolverProcessor processor = new VariableResolverProcessor(this, containingFile);
        PsiScopesUtil.resolveAndWalk(processor, this, null);
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "resolveToVariable"));
        }
        return javaResolveResultArray;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, OurGenericsResolver.INSTANCE);
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String fqn;
        PsiElement element = this.resolve();
        if (element instanceof PsiClass && (fqn = ((PsiClass)element).getQualifiedName()) != null) {
            String string = fqn;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "getCanonicalText"));
            }
            return string;
        }
        String string = this.getCachedNormalizedText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, TYPE_EVALUATOR);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        PsiElement parent2;
        boolean parentIsMethodCall;
        IElementType i = this.getLastChildNode().getElementType();
        boolean resolvingToMethod = element instanceof PsiMethod;
        if (i == JavaTokenType.IDENTIFIER) {
            if (!(element instanceof PsiPackage)) {
                if (!(element instanceof PsiNamedElement)) {
                    return false;
                }
                String name = ((PsiNamedElement)element).getName();
                if (name == null) {
                    return false;
                }
                if (!name.equals(this.getLastChildNode().getText())) {
                    return false;
                }
            }
        } else if (i == JavaTokenType.SUPER_KEYWORD || i == JavaTokenType.THIS_KEYWORD) {
            if (!resolvingToMethod) {
                return false;
            }
            if (!((PsiMethod)element).isConstructor()) {
                return false;
            }
        }
        if ((parentIsMethodCall = (parent2 = this.getParent()) instanceof PsiMethodCallExpression) != resolvingToMethod) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.advancedResolve(true).getElement());
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "processVariants"));
        }
        DelegatingScopeProcessor filterProcessor = new DelegatingScopeProcessor(processor){
            private PsiElement myResolveContext;
            private final Set<String> myVarNames;
            {
                this.myVarNames = new THashSet<String>();
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$1", "execute"));
                }
                if (state2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$1", "execute"));
                }
                return !this.shouldProcess(element) || super.execute(element, state2);
            }

            private boolean shouldProcess(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$1", "shouldProcess"));
                }
                if (element instanceof PsiVariable) {
                    return this.ensureNonShadowedVariable((PsiVariable)element);
                }
                if (element instanceof PsiClass) {
                    return !PsiReferenceExpressionImpl.seemsScrambled((PsiClass)element);
                }
                if (element instanceof PsiPackage) {
                    return PsiReferenceExpressionImpl.this.isQualified();
                }
                if (element instanceof PsiMethod) {
                    return this.shouldProcessMethod((PsiMethod)element);
                }
                return false;
            }

            private boolean ensureNonShadowedVariable(@NotNull PsiVariable element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$1", "ensureNonShadowedVariable"));
                }
                if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                    this.myVarNames.add(element.getName());
                }
                return !(element instanceof PsiField) || !this.myVarNames.contains(element.getName());
            }

            private boolean shouldProcessMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$1", "shouldProcessMethod"));
                }
                PsiReferenceExpressionImpl ref = PsiReferenceExpressionImpl.this;
                return !method.isConstructor() && PsiReferenceExpressionImpl.hasValidQualifier(method, ref, this.myResolveContext);
            }

            @Override
            public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$1", "handleEvent"));
                }
                if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
                    this.myResolveContext = (PsiElement)associated;
                }
                super.handleEvent(event, associated);
            }
        };
        PsiScopesUtil.resolveAndWalk(filterProcessor, this, null, true);
    }

    private static boolean hasValidQualifier(PsiMethod method, PsiReferenceExpression ref, PsiElement scope) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && containingClass.isInterface() && method.hasModifierProperty("static")) {
            if (!PsiUtil.getLanguageLevel(ref).isAtLeast(LanguageLevel.JDK_1_8)) {
                return false;
            }
            PsiExpression qualifierExpression = ref.getQualifierExpression();
            if (qualifierExpression == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor(containingClass, ref, true))) {
                return true;
            }
            if (qualifierExpression instanceof PsiReferenceExpression) {
                PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (resolve2 == containingClass) {
                    return true;
                }
                if (resolve2 instanceof PsiTypeParameter) {
                    HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                    for (PsiClassType type2 : ((PsiTypeParameter)resolve2).getExtendsListTypes()) {
                        PsiClass aClass2 = type2.resolve();
                        if (aClass2 == null) continue;
                        classes2.add(aClass2);
                    }
                    if (classes2.size() == 1 && classes2.contains(containingClass)) {
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static boolean seemsScrambled(@Nullable PsiClass aClass2) {
        return aClass2 instanceof PsiCompiledElement && PsiReferenceExpressionImpl.seemsScrambledByStructure(aClass2);
    }

    public static boolean seemsScrambledByStructure(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "seemsScrambledByStructure"));
        }
        PsiClass containingClass = aClass2.getContainingClass();
        if (containingClass != null && !PsiReferenceExpressionImpl.seemsScrambledByStructure(containingClass)) {
            return false;
        }
        if (PsiReferenceExpressionImpl.seemsScrambled(aClass2.getName())) {
            List<PsiMethod> methods2 = ContainerUtil.filter(aClass2.getMethods(), method -> !method.hasModifierProperty("private"));
            return !methods2.isEmpty() && ContainerUtil.and(methods2, method -> PsiReferenceExpressionImpl.seemsScrambled(method.getName()));
        }
        return false;
    }

    private static boolean seemsScrambled(String name) {
        return name != null && !name.isEmpty() && name.length() <= 2;
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        return refName == null ? super.getTextOffset() : refName.getStartOffset();
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.getQualifierExpression() != null) {
            return this.renameDirectly(newElementName);
        }
        JavaResolveResult resolveResult = this.advancedResolve(false);
        if (resolveResult.getElement() == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
        if (!(currentFileResolveScope instanceof PsiImportStaticStatement) || ((PsiImportStaticStatement)currentFileResolveScope).isOnDemand()) {
            return this.renameDirectly(newElementName);
        }
        PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
        String referenceName = importStaticStatement.getReferenceName();
        LOG.assertTrue(referenceName != null);
        PsiElement element = importStaticStatement.getImportReference().resolve();
        if (this.getManager().areElementsEquivalent(element, resolveResult.getElement())) {
            return this.renameDirectly(newElementName);
        }
        PsiClass psiClass = importStaticStatement.resolveTargetClass();
        if (psiClass == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        PsiReferenceExpression expression2 = (PsiReferenceExpression)factory2.createExpressionFromText("X." + newElementName, this);
        PsiReferenceExpression result2 = (PsiReferenceExpression)this.replace(expression2);
        ((PsiReferenceExpression)result2.getQualifierExpression()).bindToElement(psiClass);
        return result2;
    }

    private PsiElement renameDirectly(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName) || Comparing.strEqual(oldRefName, newElementName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "bindToElement"));
        }
        CheckUtil.checkWritable(this);
        if (this.isReferenceTo(element)) {
            return this;
        }
        PsiManager manager = this.getManager();
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        if (element instanceof PsiClass) {
            boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance(this.getProject()).useFQClassNames() && PsiReferenceExpressionImpl.isFullyQualified(this);
            String qName = ((PsiClass)element).getQualifiedName();
            if (qName == null) {
                qName = ((PsiClass)element).getName();
            } else if (JavaPsiFacade.getInstance(manager.getProject()).findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
                return this;
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, this);
            this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(manager.getProject());
            if (!preserveQualification) {
                ref = (PsiExpression)codeStyleManager.shortenClassReferences(ref, 8192);
            }
            return ref;
        }
        if (element instanceof PsiPackage) {
            String qName = ((PsiPackage)element).getQualifiedName();
            if (qName.isEmpty()) {
                throw new IncorrectOperationException();
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, this);
            this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
            return ref;
        }
        if ((element instanceof PsiField || element instanceof PsiMethod) && ((PsiMember)element).hasModifierProperty("static")) {
            if (!this.isPhysical()) {
                return this;
            }
            PsiMember member = (PsiMember)element;
            PsiClass psiClass = member.getContainingClass();
            if (psiClass == null) {
                throw new IncorrectOperationException();
            }
            String qName = psiClass.getQualifiedName() + "." + member.getName();
            PsiExpression ref = parserFacade.createExpressionFromText(qName, this);
            this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
            return ref;
        }
        throw new IncorrectOperationException(element.toString());
    }

    private static boolean isFullyQualified(CompositeElement classRef) {
        ASTNode qualifier = classRef.findChildByRole(54);
        if (qualifier == null) {
            return false;
        }
        if (qualifier.getElementType() != JavaElementType.REFERENCE_EXPRESSION) {
            return false;
        }
        PsiElement refElement = ((PsiReference)((Object)qualifier)).resolve();
        return refElement instanceof PsiPackage || PsiReferenceExpressionImpl.isFullyQualified((CompositeElement)qualifier);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "deleteChildInternal"));
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByRole(55);
            super.deleteChildInternal(child);
            this.deleteChildInternal(dot);
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 53: {
                if (this.getChildRole(this.getLastChildNode()) == role) {
                    return this.getLastChildNode();
                }
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                if (this.getChildRole(this.getFirstChildNode()) == 54) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 246: {
                return this.findChildByType(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            case 55: 
        }
        return this.findChildByType(JavaTokenType.DOT);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaTokenType.IDENTIFIER || i == JavaTokenType.THIS_KEYWORD || i == JavaTokenType.SUPER_KEYWORD) {
            return 53;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 54;
        }
        return 0;
    }

    @Override
    public PsiReference getReference() {
        if (this.getReferenceNameElement() == null) {
            return null;
        }
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiReferenceExpression:" + this.getText();
    }

    @Override
    public TextRange getRangeInElement() {
        return PsiJavaCodeReferenceElementImpl.calcRangeInElement(this);
    }

    @Override
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName(this.getCachedNormalizedText(), false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl", "fullyQualify"));
        }
        JavaSourceUtil.fullyQualifyReference(this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getChildRole(this.getFirstChildNode()) == 54;
    }

    private String getCachedNormalizedText() {
        String whiteSpaceAndComments = this.myCachedNormalizedText;
        if (whiteSpaceAndComments == null) {
            this.myCachedNormalizedText = whiteSpaceAndComments = JavaSourceUtil.getReferenceText(this);
        }
        return whiteSpaceAndComments;
    }

    private static class TypeEvaluator
    implements NullableFunction<PsiReferenceExpressionImpl, PsiType> {
        private TypeEvaluator() {
        }

        @Override
        public PsiType fun(PsiReferenceExpressionImpl expr) {
            PsiElement resolve2;
            PsiFile file = expr.getContainingFile();
            Project project = file.getProject();
            ResolveResult[] results = ResolveCache.getInstance(project).resolveWithCaching(expr, OurGenericsResolver.INSTANCE, true, false, file);
            JavaResolveResult result2 = results.length == 1 ? (JavaResolveResult)results[0] : null;
            PsiElement psiElement = resolve2 = result2 == null ? null : result2.getElement();
            if (resolve2 == null) {
                PsiType type2;
                ASTNode qualifier;
                ASTNode refName = expr.findChildByRole(53);
                if (refName != null && "length".equals(refName.getText()) && (qualifier = expr.findChildByRole(54)) != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier.getElementType()) && (type2 = ((PsiExpression)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).getType()) instanceof PsiArrayType) {
                    return PsiType.INT;
                }
                return null;
            }
            PsiNameIdentifierOwner owner = null;
            PsiType ret = null;
            if (resolve2 instanceof PsiVariable) {
                PsiType type3 = ((PsiVariable)resolve2).getType();
                PsiType psiType = ret = type3 instanceof PsiEllipsisType ? ((PsiEllipsisType)type3).toArrayType() : type3;
                if (ret != null && !ret.isValid()) {
                    LOG.error("invalid type of " + resolve2 + " of class " + resolve2.getClass() + ", valid=" + resolve2.isValid());
                }
                if (resolve2 instanceof PsiField && !((PsiField)resolve2).hasModifierProperty("static")) {
                    owner = ((PsiField)resolve2).getContainingClass();
                }
            } else if (resolve2 instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)resolve2;
                ret = method.getReturnType();
                if (ret != null) {
                    PsiUtil.ensureValidType(ret);
                }
                owner = method;
            }
            if (ret == null) {
                return null;
            }
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file);
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                PsiSubstitutor substitutor2 = result2.getSubstitutor();
                if (owner == null || !PsiUtil.isRawSubstitutor(owner, substitutor2)) {
                    PsiType substitutedType = substitutor2.substitute(ret);
                    PsiUtil.ensureValidType(substitutedType);
                    PsiType normalized = PsiImplUtil.normalizeWildcardTypeByPosition(substitutedType, expr);
                    PsiUtil.ensureValidType(normalized);
                    return PsiClassImplUtil.correctType(normalized, expr.getResolveScope());
                }
            }
            return PsiClassImplUtil.correctType(TypeConversionUtil.erasure(ret), expr.getResolveScope());
        }
    }

    public static final class OurGenericsResolver
    implements ResolveCache.PolyVariantContextResolver<PsiJavaReference> {
        public static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver", "resolve"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver", "resolve"));
            }
            PsiReferenceExpressionImpl expression2 = (PsiReferenceExpressionImpl)ref;
            CompositeElement treeParent = expression2.getTreeParent();
            IElementType parentType = treeParent == null ? null : treeParent.getElementType();
            List<ResolveResult[]> qualifiers = OurGenericsResolver.resolveAllQualifiers(expression2, containingFile);
            ResolveResult[] result2 = expression2.resolve(parentType, containingFile);
            if (result2.length == 0 && incompleteCode && parentType != JavaElementType.REFERENCE_EXPRESSION) {
                result2 = expression2.resolve(JavaElementType.REFERENCE_EXPRESSION, containingFile);
            }
            JavaResolveUtil.substituteResults(expression2, (JavaResolveResult[])result2);
            qualifiers.clear();
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver", "resolve"));
            }
            return result2;
        }

        @NotNull
        private static List<ResolveResult[]> resolveAllQualifiers(@NotNull PsiReferenceExpressionImpl expression2, final @NotNull PsiFile containingFile) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver", "resolveAllQualifiers"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver", "resolveAllQualifiers"));
            }
            PsiElement qualifier = expression2.getQualifier();
            if (qualifier == null) {
                List<ResolveResult[]> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver", "resolveAllQualifiers"));
                }
                return list2;
            }
            final SmartList<ResolveResult[]> qualifiers = new SmartList<ResolveResult[]>();
            final ResolveCache resolveCache = ResolveCache.getInstance(containingFile.getProject());
            qualifier.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    if (!(expression2 instanceof PsiReferenceExpressionImpl)) {
                        return;
                    }
                    ResolveResult[] cachedResults = resolveCache.getCachedResults(expression2, true, false, true);
                    if (cachedResults != null) {
                        return;
                    }
                    this.visitElement(expression2);
                }

                @Override
                protected void elementFinished(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver$1", "elementFinished"));
                    }
                    if (!(element instanceof PsiReferenceExpressionImpl)) {
                        return;
                    }
                    PsiReferenceExpressionImpl expression2 = (PsiReferenceExpressionImpl)element;
                    qualifiers.add(resolveCache.resolveWithCaching(expression2, INSTANCE, false, false, containingFile));
                }

                @Override
                public void visitExpressionList(PsiExpressionList list2) {
                }

                @Override
                public void visitLambdaExpression(PsiLambdaExpression expression2) {
                }

                @Override
                public void visitClass(PsiClass aClass2) {
                }
            });
            SmartList<ResolveResult[]> smartList = qualifiers;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver", "resolveAllQualifiers"));
            }
            return smartList;
        }
    }
}

