/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.keyFMap;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.KeyFMap;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.MapBackedFMap;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.OneElementFMap;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.PairElementsFMap;

public class ArrayBackedFMap
implements KeyFMap {
    private final int[] keys;
    private final Object[] values;

    ArrayBackedFMap(@NotNull int[] keys2, @NotNull Object[] values2) {
        if (keys2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "<init>"));
        }
        if (values2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "<init>"));
        }
        this.keys = keys2;
        this.values = values2;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
        }
        int keyCode = key.hashCode();
        int keyPos = this.indexOf(keyCode);
        if (keyPos >= 0) {
            if (this.values[keyPos] == value) {
                ArrayBackedFMap arrayBackedFMap = this;
                if (arrayBackedFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
                }
                return arrayBackedFMap;
            }
            Object[] newValues = (Object[])this.values.clone();
            newValues[keyPos] = value;
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(this.keys, newValues);
            if (arrayBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
            }
            return arrayBackedFMap;
        }
        if (this.size() < 8) {
            int[] newKeys = ArrayUtil.insert(this.keys, -keyPos - 1, keyCode);
            Object[] newValues = ArrayUtil.insert(this.values, -keyPos - 1, value);
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(newKeys, newValues);
            if (arrayBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
            }
            return arrayBackedFMap;
        }
        MapBackedFMap mapBackedFMap = new MapBackedFMap(this.keys, keyCode, this.values, value);
        if (mapBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
        }
        return mapBackedFMap;
    }

    public int size() {
        return this.keys.length;
    }

    private int indexOf(int keyCode) {
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (key == keyCode) {
                return i;
            }
            if (key <= keyCode) continue;
            return -i - 1;
        }
        return -this.keys.length - 1;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
        }
        int i = this.indexOf(key.hashCode());
        if (i >= 0) {
            if (this.size() == 3) {
                int i1 = (2 - i) / 2;
                int i2 = 3 - (i + 2) / 2;
                Key key1 = Key.getKeyByIndex(this.keys[i1]);
                Key key2 = Key.getKeyByIndex(this.keys[i2]);
                if (key1 == null && key2 == null) {
                    KeyFMap keyFMap = EMPTY_MAP;
                    if (keyFMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
                    }
                    return keyFMap;
                }
                if (key1 == null) {
                    OneElementFMap oneElementFMap = new OneElementFMap(key2, this.values[i2]);
                    if (oneElementFMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
                    }
                    return oneElementFMap;
                }
                if (key2 == null) {
                    OneElementFMap oneElementFMap = new OneElementFMap(key1, this.values[i1]);
                    if (oneElementFMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
                    }
                    return oneElementFMap;
                }
                PairElementsFMap pairElementsFMap = new PairElementsFMap(key1, this.values[i1], key2, this.values[i2]);
                if (pairElementsFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
                }
                return pairElementsFMap;
            }
            int[] newKeys = ArrayUtil.remove(this.keys, i);
            Object[] newValues = ArrayUtil.remove(this.values, i, ArrayUtil.OBJECT_ARRAY_FACTORY);
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(newKeys, newValues);
            if (arrayBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
            }
            return arrayBackedFMap;
        }
        ArrayBackedFMap arrayBackedFMap = this;
        if (arrayBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
        }
        return arrayBackedFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "get"));
        }
        int i = this.indexOf(key.hashCode());
        return (V)(i < 0 ? null : this.values[i]);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            Object value = this.values[i];
            s.append(s.length() == 1 ? "" : ", ").append(Key.getKeyByIndex(key)).append("=").append(value);
        }
        return s.append("}").toString();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        Key[] keyArray = ArrayBackedFMap.getKeysByIndices(this.keys);
        if (keyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "getKeys"));
        }
        return keyArray;
    }

    @NotNull
    static Key[] getKeysByIndices(int[] indexes) {
        Key[] result2 = new Key[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            result2[i] = Key.getKeyByIndex(indexes[i]);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap", "getKeysByIndices"));
        }
        return result2;
    }

    public int hashCode() {
        int hash = 0;
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            hash += this.keys[i] ^ this.values[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayBackedFMap)) {
            return false;
        }
        ArrayBackedFMap map2 = (ArrayBackedFMap)o;
        if (map2.size() != this.size()) {
            return false;
        }
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            if (this.keys[i] == map2.keys[i] && this.values[i].equals(map2.values[i])) continue;
            return false;
        }
        return true;
    }
}

