/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbstractTypeConstructor;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

public abstract class AbstractClassTypeConstructor
extends AbstractTypeConstructor
implements TypeConstructor {
    private int hashCode;

    public AbstractClassTypeConstructor(@NotNull StorageManager storageManager) {
        if (storageManager == null) {
            AbstractClassTypeConstructor.$$$reportNull$$$0(0);
        }
        super(storageManager);
        this.hashCode = 0;
    }

    public final int hashCode() {
        int currentHashCode = this.hashCode;
        if (currentHashCode != 0) {
            return currentHashCode;
        }
        ClassifierDescriptor descriptor2 = this.getDeclarationDescriptor();
        currentHashCode = descriptor2 instanceof ClassDescriptor && AbstractClassTypeConstructor.hasMeaningfulFqName(descriptor2) ? DescriptorUtils.getFqName(descriptor2).hashCode() : System.identityHashCode(this);
        this.hashCode = currentHashCode;
        return currentHashCode;
    }

    @Override
    @NotNull
    public abstract ClassifierDescriptor getDeclarationDescriptor();

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = DescriptorUtilsKt.getBuiltIns(this.getDeclarationDescriptor());
        if (kotlinBuiltIns == null) {
            AbstractClassTypeConstructor.$$$reportNull$$$0(1);
        }
        return kotlinBuiltIns;
    }

    public final boolean equals(Object other) {
        ClassifierDescriptor otherDescriptor;
        if (!(other instanceof TypeConstructor)) {
            return false;
        }
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        if (((TypeConstructor)other).getParameters().size() != this.getParameters().size()) {
            return false;
        }
        ClassifierDescriptor myDescriptor = this.getDeclarationDescriptor();
        if (myDescriptor == (otherDescriptor = ((TypeConstructor)other).getDeclarationDescriptor())) {
            return true;
        }
        if (!AbstractClassTypeConstructor.hasMeaningfulFqName(myDescriptor) || otherDescriptor != null && !AbstractClassTypeConstructor.hasMeaningfulFqName(otherDescriptor)) {
            return this == other;
        }
        if (myDescriptor instanceof ClassDescriptor && otherDescriptor instanceof ClassDescriptor) {
            return AbstractClassTypeConstructor.areFqNamesEqual((ClassDescriptor)myDescriptor, (ClassDescriptor)otherDescriptor);
        }
        return false;
    }

    private static boolean areFqNamesEqual(ClassDescriptor first, ClassDescriptor second) {
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        DeclarationDescriptor a = first.getContainingDeclaration();
        for (DeclarationDescriptor b = second.getContainingDeclaration(); a != null && b != null; a = a.getContainingDeclaration(), b = b.getContainingDeclaration()) {
            if (a instanceof ModuleDescriptor) {
                return b instanceof ModuleDescriptor;
            }
            if (b instanceof ModuleDescriptor) {
                return false;
            }
            if (a instanceof PackageFragmentDescriptor) {
                return b instanceof PackageFragmentDescriptor && ((PackageFragmentDescriptor)a).getFqName().equals(((PackageFragmentDescriptor)b).getFqName());
            }
            if (b instanceof PackageFragmentDescriptor) {
                return false;
            }
            if (a.getName().equals(b.getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasMeaningfulFqName(@NotNull ClassifierDescriptor descriptor2) {
        if (descriptor2 == null) {
            AbstractClassTypeConstructor.$$$reportNull$$$0(2);
        }
        return !ErrorUtils.isError(descriptor2) && !DescriptorUtils.isLocal(descriptor2);
    }

    @Override
    @NotNull
    protected Collection<KotlinType> getAdditionalNeighboursInSupertypeGraph() {
        DeclarationDescriptor containingDeclaration = this.getDeclarationDescriptor().getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            Set<KotlinType> set = Collections.singleton(((ClassDescriptor)containingDeclaration).getDefaultType());
            if (set == null) {
                AbstractClassTypeConstructor.$$$reportNull$$$0(3);
            }
            return set;
        }
        List<KotlinType> list2 = Collections.emptyList();
        if (list2 == null) {
            AbstractClassTypeConstructor.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/AbstractClassTypeConstructor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/AbstractClassTypeConstructor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltIns";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalNeighboursInSupertypeGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasMeaningfulFqName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

