/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludedBuildDependencySubstitutionsBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludedBuildDependencySubstitutionsBuilder.class);
    private final CompositeBuildContext context;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public IncludedBuildDependencySubstitutionsBuilder(CompositeBuildContext context, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.context = context;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public void build(IncludedBuildInternal build) {
        DependencySubstitutionsInternal substitutions = this.resolveDependencySubstitutions(build);
        if (!substitutions.hasRules()) {
            LOGGER.info("[composite-build] Configuring build: " + build.getProjectDir());
            GradleInternal gradle = build.getConfiguredBuild();
            for (Project project : gradle.getRootProject().getAllprojects()) {
                this.registerProject((IncludedBuild)build, (ProjectInternal)project);
            }
        } else {
            this.context.registerSubstitution(substitutions.getRuleAction());
        }
    }

    private void registerProject(IncludedBuild build, ProjectInternal project) {
        LocalComponentRegistry localComponentRegistry = (LocalComponentRegistry)project.getServices().get(LocalComponentRegistry.class);
        ProjectComponentIdentifier originalIdentifier = DefaultProjectComponentIdentifier.newProjectId((Project)project);
        DefaultLocalComponentMetadata originalComponent = (DefaultLocalComponentMetadata)localComponentRegistry.getComponent(originalIdentifier);
        ProjectComponentIdentifier componentIdentifier = DefaultProjectComponentIdentifier.newProjectId((IncludedBuild)build, (String)project.getPath());
        this.context.registerSubstitution(originalComponent.getId(), componentIdentifier);
    }

    private DependencySubstitutionsInternal resolveDependencySubstitutions(IncludedBuildInternal build) {
        DefaultDependencySubstitutions dependencySubstitutions = DefaultDependencySubstitutions.forIncludedBuild((IncludedBuild)build, (ImmutableModuleIdentifierFactory)this.moduleIdentifierFactory);
        for (Action<? super DependencySubstitutions> action : build.getRegisteredDependencySubstitutions()) {
            action.execute((Object)dependencySubstitutions);
        }
        return dependencySubstitutions;
    }
}

