/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.util.Collection;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationInitializer;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotProvider;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

class SelectiveCompiler
implements Compiler<JavaCompileSpec> {
    private static final Logger LOG = Logging.getLogger(SelectiveCompiler.class);
    private final IncrementalTaskInputs inputs;
    private final PreviousCompilation previousCompilation;
    private final CleaningJavaCompiler cleaningCompiler;
    private final RecompilationSpecProvider recompilationSpecProvider;
    private final IncrementalCompilationInitializer incrementalCompilationInitilizer;
    private final JarClasspathSnapshotProvider jarClasspathSnapshotProvider;

    public SelectiveCompiler(IncrementalTaskInputs inputs, PreviousCompilation previousCompilation, CleaningJavaCompiler cleaningCompiler, RecompilationSpecProvider recompilationSpecProvider, IncrementalCompilationInitializer compilationInitializer, JarClasspathSnapshotProvider jarClasspathSnapshotProvider) {
        this.inputs = inputs;
        this.previousCompilation = previousCompilation;
        this.cleaningCompiler = cleaningCompiler;
        this.recompilationSpecProvider = recompilationSpecProvider;
        this.incrementalCompilationInitilizer = compilationInitializer;
        this.jarClasspathSnapshotProvider = jarClasspathSnapshotProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkResult execute(JavaCompileSpec spec) {
        Timer clock = Time.startTimer();
        CurrentCompilation currentCompilation = new CurrentCompilation(this.inputs, spec, this.jarClasspathSnapshotProvider);
        RecompilationSpec recompilationSpec = this.recompilationSpecProvider.provideRecompilationSpec(currentCompilation, this.previousCompilation);
        if (recompilationSpec.isFullRebuildNeeded()) {
            LOG.info("Full recompilation is required because {}. Analysis took {}.", (Object)recompilationSpec.getFullRebuildCause(), (Object)clock.getElapsed());
            return this.cleaningCompiler.execute(spec);
        }
        this.incrementalCompilationInitilizer.initializeCompilation(spec, recompilationSpec);
        if (spec.getSource().isEmpty() && spec.getClasses().isEmpty()) {
            LOG.info("None of the classes needs to be compiled! Analysis took {}. ", (Object)clock.getElapsed());
            return new RecompilationNotNecessary();
        }
        try {
            WorkResult workResult = this.cleaningCompiler.getCompiler().execute((CompileSpec)spec);
            return workResult;
        }
        finally {
            Collection<String> classesToCompile = recompilationSpec.getClassesToCompile();
            LOG.info("Incremental compilation of {} classes completed in {}.", (Object)classesToCompile.size(), (Object)clock.getElapsed());
            LOG.debug("Recompiled classes {}", classesToCompile);
        }
    }
}

