/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicModulesClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;
    private static final String[] GRADLE_EXTENSION_MODULES = new String[]{"gradle-workers", "gradle-dependency-management", "gradle-plugin-use"};
    private static final String[] GRADLE_OPTIONAL_EXTENSION_MODULES = new String[]{"gradle-kotlin-dsl-provider-plugins", "gradle-kotlin-dsl-tooling-builders"};

    public DynamicModulesClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
    }

    @Override
    public ClassPath findClassPath(String name) {
        if (name.equals("GRADLE_EXTENSIONS")) {
            Set<Module> coreModules = this.allRequiredModulesOf("gradle-core");
            ClassPath classpath = ClassPath.EMPTY;
            for (String moduleName : GRADLE_EXTENSION_MODULES) {
                Set<Module> extensionModules = this.allRequiredModulesOf(moduleName);
                classpath = this.plusExtensionModules(classpath, extensionModules, coreModules);
            }
            for (String moduleName : GRADLE_OPTIONAL_EXTENSION_MODULES) {
                Set<Module> optionalExtensionModules = this.allRequiredModulesOfOptional(moduleName);
                classpath = this.plusExtensionModules(classpath, optionalExtensionModules, coreModules);
            }
            for (Module pluginModule : this.pluginModuleRegistry.getApiModules()) {
                classpath = classpath.plus(pluginModule.getClasspath());
            }
            for (Module pluginModule : this.pluginModuleRegistry.getImplementationModules()) {
                classpath = classpath.plus(pluginModule.getClasspath());
            }
            return classpath;
        }
        return null;
    }

    private Set<Module> allRequiredModulesOf(String name) {
        return this.moduleRegistry.getModule(name).getAllRequiredModules();
    }

    private Set<Module> allRequiredModulesOfOptional(String moduleName) {
        Module optionalModule = this.moduleRegistry.findModule(moduleName);
        if (optionalModule != null) {
            return optionalModule.getAllRequiredModules();
        }
        return Collections.emptySet();
    }

    private ClassPath plusExtensionModules(ClassPath classpath, Set<Module> extensionModules, Set<Module> coreModules) {
        for (Module module : extensionModules) {
            if (coreModules.contains(module)) continue;
            classpath = classpath.plus(module.getClasspath());
        }
        return classpath;
    }
}

