/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ComponentStateFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;

class SelectorStateResolverResults {
    public final Map<ResolvableSelectorState, ComponentIdResolveResult> results = Maps.newLinkedHashMap();

    SelectorStateResolverResults() {
    }

    public <T extends ComponentResolutionState> List<T> getResolved(ComponentStateFactory<T> componentFactory) {
        ModuleVersionResolveException failure = null;
        HashSet processedResolveResults = Sets.newHashSet();
        ArrayList resolved = Lists.newArrayList();
        for (ResolvableSelectorState selectorState : this.results.keySet()) {
            ComponentIdResolveResult idResolveResult = this.results.get(selectorState);
            if (selectorState.isForce()) {
                T forcedComponent = SelectorStateResolverResults.componentForIdResolveResult(componentFactory, idResolveResult, selectorState);
                forcedComponent.addCause(VersionSelectionReasons.FORCED);
                return Collections.singletonList(forcedComponent);
            }
            if (!processedResolveResults.add(idResolveResult)) continue;
            if (idResolveResult.getFailure() == null) {
                T componentState = SelectorStateResolverResults.componentForIdResolveResult(componentFactory, idResolveResult, selectorState);
                resolved.add(componentState);
                continue;
            }
            if (failure != null) continue;
            failure = idResolveResult.getFailure();
        }
        if (resolved.isEmpty() && failure != null) {
            throw failure;
        }
        return resolved;
    }

    public static <T extends ComponentResolutionState> T componentForIdResolveResult(ComponentStateFactory<T> componentFactory, ComponentIdResolveResult idResolveResult, ResolvableSelectorState selector) {
        T component = componentFactory.getRevision(idResolveResult.getId(), idResolveResult.getModuleVersionId(), idResolveResult.getMetadata());
        component.selectedBy(selector);
        if (idResolveResult.isRejected()) {
            component.reject();
        }
        return component;
    }

    boolean alreadyHaveResolution(ResolvableSelectorState dep) {
        for (ComponentIdResolveResult discovered : this.results.values()) {
            if (!this.included(dep, discovered)) continue;
            this.results.put(dep, discovered);
            return true;
        }
        return false;
    }

    void registerResolution(ResolvableSelectorState dep, ComponentIdResolveResult resolveResult) {
        if (resolveResult.getFailure() != null) {
            this.results.put(dep, resolveResult);
            return;
        }
        for (ResolvableSelectorState other : this.results.keySet()) {
            if (!this.included(other, resolveResult)) continue;
            this.results.put(other, resolveResult);
        }
        this.results.put(dep, resolveResult);
    }

    private boolean included(ResolvableSelectorState dep, ComponentIdResolveResult candidate) {
        VersionSelector preferredSelector;
        if (candidate.getFailure() != null) {
            return false;
        }
        ResolvedVersionConstraint versionConstraint = dep.getVersionConstraint();
        VersionSelector versionSelector = preferredSelector = versionConstraint == null ? null : versionConstraint.getPreferredSelector();
        if (preferredSelector == null || !preferredSelector.canShortCircuitWhenVersionAlreadyPreselected()) {
            return false;
        }
        return preferredSelector.accept(candidate.getModuleVersionId().getVersion());
    }
}

