/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.service.MethodHandleBasedServiceMethod;
import org.gradle.internal.service.ReflectionBasedServiceMethod;
import org.gradle.internal.service.ServiceMethod;
import org.gradle.internal.service.ServiceMethodFactory;

class MethodHandleBasedServiceMethodFactory
implements ServiceMethodFactory {
    public MethodHandleBasedServiceMethodFactory() {
        try {
            Class.forName("java.lang.invoke.MethodHandle");
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public ServiceMethod toServiceMethod(Method method) {
        if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            try {
                return new MethodHandleBasedServiceMethod(method);
            }
            catch (IllegalAccessException ex) {
                return new ReflectionBasedServiceMethod(method);
            }
        }
        return new ReflectionBasedServiceMethod(method);
    }
}

