/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddressSerializer;
import org.gradle.internal.remote.internal.inet.SocketInetAddress;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonRegistryContent
implements Serializable {
    public static final org.gradle.internal.serialize.Serializer<DaemonRegistryContent> SERIALIZER = new Serializer();
    private static final MultiChoiceAddressSerializer MULTI_CHOICE_ADDRESS_SERIALIZER = new MultiChoiceAddressSerializer();
    private final Map<Address, DaemonInfo> infosMap;
    private final List<DaemonStopEvent> stopEvents;

    public DaemonRegistryContent() {
        this.infosMap = new HashMap<Address, DaemonInfo>();
        this.stopEvents = new ArrayList<DaemonStopEvent>();
    }

    private DaemonRegistryContent(Map<Address, DaemonInfo> infosMap, List<DaemonStopEvent> stopEvents) {
        this.infosMap = infosMap;
        this.stopEvents = stopEvents;
    }

    public List<DaemonInfo> getInfos() {
        return new LinkedList<DaemonInfo>(this.infosMap.values());
    }

    public DaemonInfo getInfo(Address address) {
        return this.infosMap.get(address);
    }

    public void removeInfo(Address address) {
        this.infosMap.remove(address);
    }

    public List<DaemonStopEvent> getStopEvents() {
        return this.stopEvents;
    }

    public void addStopEvent(DaemonStopEvent stopEvent) {
        this.stopEvents.add(stopEvent);
    }

    public void removeStopEvents(Collection<DaemonStopEvent> events) {
        this.stopEvents.removeAll(events);
    }

    public void setStatus(Address address, DaemonInfo daemonInfo) {
        this.infosMap.put(address, daemonInfo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Serializer
    implements org.gradle.internal.serialize.Serializer<DaemonRegistryContent> {
        private Serializer() {
        }

        public DaemonRegistryContent read(Decoder decoder) throws Exception {
            if (decoder.readBoolean()) {
                List<Address> addresses = this.readAdresses(decoder);
                Map<Address, DaemonInfo> infosMap = this.readInfosMap(decoder, addresses);
                List<DaemonStopEvent> stopEvents = this.readStopEvents(decoder);
                return new DaemonRegistryContent(infosMap, stopEvents);
            }
            return null;
        }

        private List<DaemonStopEvent> readStopEvents(Decoder decoder) throws Exception {
            int len = decoder.readInt();
            ArrayList<DaemonStopEvent> out = new ArrayList<DaemonStopEvent>(len);
            for (int i = 0; i < len; ++i) {
                out.add((DaemonStopEvent)DaemonStopEvent.SERIALIZER.read(decoder));
            }
            return out;
        }

        private Map<Address, DaemonInfo> readInfosMap(Decoder decoder, List<Address> addresses) throws Exception {
            HashMap<Address, DaemonInfo> infosMap = new HashMap<Address, DaemonInfo>(addresses.size());
            DaemonInfo.Serializer daemonInfoSerializer = new DaemonInfo.Serializer(addresses);
            for (Address address : addresses) {
                infosMap.put(address, daemonInfoSerializer.read(decoder));
            }
            return infosMap;
        }

        public void write(Encoder encoder, DaemonRegistryContent registry) throws Exception {
            if (registry != null) {
                encoder.writeBoolean(true);
                Map infosMap = registry.infosMap;
                int infosSize = infosMap.size();
                ArrayList<Address> addresses = new ArrayList<Address>(infosMap.keySet());
                this.writeAddresses(encoder, infosSize, addresses);
                this.writeDaemonInfos(encoder, infosMap, addresses);
                this.writeStopEvents(encoder, registry);
            } else {
                encoder.writeBoolean(false);
            }
        }

        private void writeStopEvents(Encoder encoder, DaemonRegistryContent registry) throws Exception {
            List stopEvents = registry.stopEvents;
            encoder.writeInt(stopEvents.size());
            for (DaemonStopEvent stopEvent : stopEvents) {
                DaemonStopEvent.SERIALIZER.write(encoder, (Object)stopEvent);
            }
        }

        private void writeDaemonInfos(Encoder encoder, Map<Address, DaemonInfo> infosMap, List<Address> addresses) throws Exception {
            DaemonInfo.Serializer daemonInfoSerializer = new DaemonInfo.Serializer(addresses);
            for (Address address : addresses) {
                DaemonInfo info = infosMap.get(address);
                daemonInfoSerializer.write(encoder, info);
            }
        }

        private void writeAddresses(Encoder encoder, int infosSize, List<Address> addresses) throws Exception {
            encoder.writeInt(infosSize);
            block4: for (Address address : addresses) {
                byte type = (byte)(address instanceof SocketInetAddress ? 0 : (address instanceof MultiChoiceAddress ? 1 : 2));
                encoder.writeByte(type);
                switch (type) {
                    case 0: {
                        SocketInetAddress.SERIALIZER.write(encoder, (Object)((SocketInetAddress)address));
                        continue block4;
                    }
                    case 1: {
                        MULTI_CHOICE_ADDRESS_SERIALIZER.write(encoder, (MultiChoiceAddress)address);
                        continue block4;
                    }
                }
                ObjectOutputStream oos = new ObjectOutputStream(encoder.getOutputStream());
                oos.writeObject(address);
            }
        }

        private List<Address> readAdresses(Decoder decoder) throws Exception {
            int infosSize = decoder.readInt();
            ArrayList<Address> out = new ArrayList<Address>();
            block4: for (int i = 0; i < infosSize; ++i) {
                byte type = decoder.readByte();
                switch (type) {
                    case 0: {
                        out.add((Address)SocketInetAddress.SERIALIZER.read(decoder));
                        continue block4;
                    }
                    case 1: {
                        out.add((Address)MULTI_CHOICE_ADDRESS_SERIALIZER.read(decoder));
                        continue block4;
                    }
                    default: {
                        ObjectInputStream ois = new ObjectInputStream(decoder.getInputStream());
                        out.add((Address)ois.readObject());
                    }
                }
            }
            return out;
        }
    }
}

