/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildableSingleResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformArtifactOperation;
import org.gradle.api.internal.artifacts.transform.TransformFileOperation;
import org.gradle.api.internal.artifacts.transform.UserCodeBackedTransformer;
import org.gradle.execution.taskgraph.TaskDependencyResolver;
import org.gradle.execution.taskgraph.WorkInfo;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public abstract class TransformInfo
extends WorkInfo {
    private static final AtomicInteger ORDER_COUNTER = new AtomicInteger();
    private final int order = ORDER_COUNTER.incrementAndGet();
    protected final UserCodeBackedTransformer artifactTransformer;
    protected List<File> result;
    protected Throwable failure;

    public static TransformInfo from(List<UserCodeBackedTransformer> transformerChain, BuildableSingleResolvedArtifactSet artifact) {
        TransformInfo current;
        Iterator<UserCodeBackedTransformer> iterator = transformerChain.iterator();
        TransformInfo previous = null;
        do {
            UserCodeBackedTransformer transformer = iterator.next();
            current = previous == null ? new InitialTransformInfo(transformer, artifact) : new ChainedTransformInfo(transformer, previous);
            previous = current;
        } while (iterator.hasNext());
        return current;
    }

    protected TransformInfo(UserCodeBackedTransformer artifactTransformer) {
        this.artifactTransformer = artifactTransformer;
    }

    public abstract void execute(BuildOperationExecutor var1);

    public String toString() {
        return this.artifactTransformer.getDisplayName();
    }

    private List<File> getResult() {
        if (this.failure != null) {
            throw new IllegalStateException("Transformation has failed", this.failure);
        }
        if (this.result == null) {
            throw new IllegalStateException("Transformation hasn't been executed yet");
        }
        return this.result;
    }

    @Nullable
    private Throwable getFailure() {
        if (this.result == null) {
            throw new IllegalStateException("Transformation hasn't been executed yet");
        }
        return this.failure;
    }

    public void prepareForExecution() {
    }

    public void collectTaskInto(ImmutableCollection.Builder<Task> builder) {
    }

    public Throwable getWorkFailure() {
        return null;
    }

    public void rethrowFailure() {
    }

    public int compareTo(WorkInfo other) {
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return ((Object)((Object)this)).getClass().getName().compareTo(other.getClass().getName());
        }
        TransformInfo otherTransform = (TransformInfo)other;
        return this.order - otherTransform.order;
    }

    private static class ResolveOnlyAsyncArtifactListener
    implements ResolvedArtifactSet.AsyncArtifactListener {
        private ResolveOnlyAsyncArtifactListener() {
        }

        @Override
        public void artifactAvailable(ResolvableArtifact artifact) {
        }

        @Override
        public boolean requireArtifactFiles() {
            return true;
        }

        @Override
        public boolean includeFileDependencies() {
            return false;
        }

        @Override
        public void fileAvailable(File file) {
        }
    }

    private static class ResolveArtifacts
    implements Action<BuildOperationQueue<RunnableBuildOperation>> {
        private final ResolvedArtifactSet artifactSet;
        private ResolvedArtifactSet.Completion result;

        public ResolveArtifacts(ResolvedArtifactSet artifactSet) {
            this.artifactSet = artifactSet;
        }

        public void execute(BuildOperationQueue<RunnableBuildOperation> actions) {
            this.result = this.artifactSet.startVisit(actions, new ResolveOnlyAsyncArtifactListener());
        }

        public ResolvedArtifactSet.Completion getResult() {
            return this.result;
        }
    }

    private static class ChainedTransformInfo
    extends TransformInfo {
        private final TransformInfo previousTransform;

        public ChainedTransformInfo(UserCodeBackedTransformer artifactTransformer, TransformInfo previousTransform) {
            super(artifactTransformer);
            this.previousTransform = previousTransform;
        }

        @Override
        public void execute(BuildOperationExecutor buildOperationExecutor) {
            Throwable previousFailure = this.previousTransform.getFailure();
            if (previousFailure != null) {
                this.failure = previousFailure;
                this.result = Collections.emptyList();
                return;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (File inputFile : this.previousTransform.getResult()) {
                TransformFileOperation operation = new TransformFileOperation(inputFile, this.artifactTransformer, BuildOperationCategory.TASK);
                buildOperationExecutor.run((RunnableBuildOperation)operation);
                if (operation.getFailure() != null) {
                    this.failure = operation.getFailure();
                    this.result = Collections.emptyList();
                    return;
                }
                List<File> result = operation.getResult();
                if (result == null) continue;
                builder.addAll(result);
            }
            this.result = builder.build();
        }

        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<WorkInfo> processHardSuccessor) {
            this.addDependencySuccessor(this.previousTransform);
            processHardSuccessor.execute((Object)this.previousTransform);
        }
    }

    private static class InitialTransformInfo
    extends TransformInfo {
        private final BuildableSingleResolvedArtifactSet artifactSet;

        public InitialTransformInfo(UserCodeBackedTransformer artifactTransformer, BuildableSingleResolvedArtifactSet artifactSet) {
            super(artifactTransformer);
            this.artifactSet = artifactSet;
        }

        @Override
        public void execute(BuildOperationExecutor buildOperationExecutor) {
            ResolveArtifacts resolveArtifacts = new ResolveArtifacts(this.artifactSet);
            buildOperationExecutor.runAll((Action)resolveArtifacts);
            ResolvedArtifactCollectingVisitor visitor = new ResolvedArtifactCollectingVisitor();
            resolveArtifacts.getResult().visit(visitor);
            Set<Throwable> failures = visitor.getFailures();
            if (!failures.isEmpty()) {
                Object failure = failures.size() == 1 && Iterables.getOnlyElement(failures) instanceof ResolveException ? (Throwable)Iterables.getOnlyElement(failures) : new DefaultLenientConfiguration.ArtifactResolveException("artifacts", this.artifactTransformer.getDisplayName(), "artifact transform", failures);
                this.failure = failure;
                this.result = Collections.emptyList();
                return;
            }
            ResolvedArtifactResult artifact = (ResolvedArtifactResult)Iterables.getOnlyElement(visitor.getArtifacts());
            TransformArtifactOperation operation = new TransformArtifactOperation(artifact.getId(), artifact.getFile(), this.artifactTransformer, BuildOperationCategory.TASK);
            buildOperationExecutor.run((RunnableBuildOperation)operation);
            this.result = operation.getResult();
            this.failure = operation.getFailure();
        }

        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<WorkInfo> processHardSuccessor) {
            Set<WorkInfo> dependencies = this.getDependencies(dependencyResolver);
            for (WorkInfo dependency : dependencies) {
                this.addDependencySuccessor(dependency);
                processHardSuccessor.execute((Object)dependency);
            }
        }

        private Set<WorkInfo> getDependencies(TaskDependencyResolver dependencyResolver) {
            return dependencyResolver.resolveDependenciesFor(null, (Object)this.artifactSet.getBuildDependencies());
        }
    }
}

