/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.osgi;

import groovy.lang.Closure;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.plugins.osgi.DefaultOsgiManifest;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.osgi.OsgiManifest;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

public class OsgiPluginConvention {
    private final ProjectInternal project;

    public OsgiPluginConvention(ProjectInternal project) {
        this.project = project;
    }

    public OsgiManifest osgiManifest() {
        return this.osgiManifest((Action<? super OsgiManifest>)Actions.doNothing());
    }

    public OsgiManifest osgiManifest(Closure closure) {
        return (OsgiManifest)ConfigureUtil.configure((Closure)closure, (Object)this.createDefaultOsgiManifest());
    }

    public OsgiManifest osgiManifest(Action<? super OsgiManifest> action) {
        OsgiManifest manifest = this.createDefaultOsgiManifest();
        action.execute((Object)manifest);
        return manifest;
    }

    private OsgiManifest createDefaultOsgiManifest() {
        OsgiManifest osgiManifest = (OsgiManifest)((Instantiator)this.project.getServices().get(Instantiator.class)).newInstance(DefaultOsgiManifest.class, new Object[]{this.project.getFileResolver()});
        ConventionMapping mapping = ((IConventionAware)osgiManifest).getConventionMapping();
        final OsgiHelper osgiHelper = new OsgiHelper();
        mapping.map("version", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return osgiHelper.getVersion(OsgiPluginConvention.this.project.getVersion().toString());
            }
        });
        mapping.map("name", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((BasePluginConvention)OsgiPluginConvention.this.project.getConvention().getPlugin(BasePluginConvention.class)).getArchivesBaseName();
            }
        });
        mapping.map("symbolicName", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return osgiHelper.getBundleSymbolicName((Project)OsgiPluginConvention.this.project);
            }
        });
        return osgiManifest;
    }
}

