/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;

class DefaultJarSnapshotter {
    private static final Logger LOGGER = Logging.getLogger(DefaultJarSnapshotter.class);
    private final StreamHasher hasher;
    private final ClassDependenciesAnalyzer analyzer;

    public DefaultJarSnapshotter(StreamHasher hasher, ClassDependenciesAnalyzer analyzer) {
        this.hasher = hasher;
        this.analyzer = analyzer;
    }

    public JarSnapshot createSnapshot(HashCode hash, JarArchive jarArchive) {
        ClassDependentsAccumulator accumulator;
        HashMap hashes;
        block2: {
            hashes = Maps.newHashMap();
            accumulator = new ClassDependentsAccumulator();
            try {
                jarArchive.contents.visit((FileVisitor)new JarVisitor(accumulator, hashes));
            }
            catch (Exception e) {
                accumulator.fullRebuildNeeded("jar file " + jarArchive.file.getName() + " could not be analyzed. See the debug log for more details");
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Could not analyze jar file " + jarArchive.file.getName(), (Throwable)e);
            }
        }
        return new JarSnapshot(new JarSnapshotData(hash, hashes, accumulator.getAnalysis()));
    }

    private class JarVisitor
    implements FileVisitor {
        private final ClassDependentsAccumulator accumulator;
        private final Map<String, HashCode> hashes;

        public JarVisitor(ClassDependentsAccumulator accumulator, Map<String, HashCode> hashes) {
            this.accumulator = accumulator;
            this.hashes = hashes;
        }

        public void visitDir(FileVisitDetails dirDetails) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitFile(FileVisitDetails fileDetails) {
            block11: {
                HashCode classFileHash;
                if (!fileDetails.getName().endsWith(".class")) {
                    return;
                }
                InputStream inputStream = fileDetails.open();
                try {
                    classFileHash = DefaultJarSnapshotter.this.hasher.hash(inputStream);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                }
                try {
                    ClassAnalysis analysis = DefaultJarSnapshotter.this.analyzer.getClassAnalysis(classFileHash, (FileTreeElement)fileDetails);
                    this.accumulator.addClass(analysis);
                    this.hashes.put(analysis.getClassName(), classFileHash);
                }
                catch (Exception e) {
                    this.accumulator.fullRebuildNeeded("class file " + fileDetails.getName() + " could not be analyzed. See the debug log for more details");
                    if (!LOGGER.isDebugEnabled()) break block11;
                    LOGGER.debug("Could not analyze class file " + fileDetails.getName(), (Throwable)e);
                }
            }
        }
    }
}

