/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.FlushOutputEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.UpdateNowEvent;
import org.gradle.internal.time.Clock;

public class ThrottlingOutputEventListener
implements OutputEventListener {
    private final OutputEventListener listener;
    private final ScheduledExecutorService executor;
    private final Clock clock;
    private final int throttleMs;
    private final Object lock = new Object();
    private long currentTimePeriod;
    private long lastUpdate;
    private final List<OutputEvent> queue = new ArrayList<OutputEvent>();

    public ThrottlingOutputEventListener(OutputEventListener listener, Clock clock) {
        this(listener, Integer.getInteger("org.gradle.internal.console.throttle", 100), Executors.newSingleThreadScheduledExecutor(), clock);
    }

    ThrottlingOutputEventListener(OutputEventListener listener, int throttleMs, ScheduledExecutorService executor, Clock clock) {
        this.throttleMs = throttleMs;
        this.listener = listener;
        this.executor = executor;
        this.clock = clock;
        this.scheduleUpdateNow();
    }

    private void scheduleUpdateNow() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            public void run() {
                ThrottlingOutputEventListener.this.onOutput(new UpdateNowEvent(ThrottlingOutputEventListener.this.clock.getCurrentTime()));
            }
        }, this.throttleMs, this.throttleMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent newEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(newEvent);
            if (newEvent instanceof UpdateNowEvent) {
                this.currentTimePeriod = ((UpdateNowEvent)newEvent).getTimestamp();
                this.renderNow();
                return;
            }
            if (newEvent instanceof FlushOutputEvent) {
                this.renderNow();
                return;
            }
            if (newEvent instanceof EndOutputEvent) {
                this.renderNow();
                this.executor.shutdown();
            }
        }
    }

    private void renderNow() {
        for (OutputEvent event : this.queue) {
            this.listener.onOutput(event);
        }
        this.queue.clear();
        this.lastUpdate = this.currentTimePeriod;
    }
}

