/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.tasks.FileNormalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileCollectionSnapshotterRegistry
implements FileCollectionSnapshotterRegistry {
    private final Map<Class<? extends FileNormalizer>, FileCollectionSnapshotter> snapshotters;

    public DefaultFileCollectionSnapshotterRegistry(Collection<FileCollectionSnapshotter> snapshotters) {
        this.snapshotters = ImmutableMap.copyOf((Map)Maps.uniqueIndex(snapshotters, (Function)new Function<FileCollectionSnapshotter, Class<? extends FileNormalizer>>(){

            public Class<? extends FileNormalizer> apply(FileCollectionSnapshotter snapshotter) {
                return snapshotter.getRegisteredType();
            }
        }));
    }

    @Override
    public Collection<FileCollectionSnapshotter> getAllSnapshotters() {
        return this.snapshotters.values();
    }

    @Override
    public FileCollectionSnapshotter getSnapshotter(Class<? extends FileNormalizer> type) {
        FileCollectionSnapshotter snapshotter = this.snapshotters.get(type);
        if (snapshotter == null) {
            throw new IllegalStateException(String.format("No snapshotter registered with type '%s'", type.getName()));
        }
        return snapshotter;
    }
}

