/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputCachingState;
import org.gradle.api.internal.tasks.DefaultTaskOutputs;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveTaskOutputCachingStateExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveTaskOutputCachingStateExecuter.class);
    private final boolean taskOutputCacheEnabled;
    private final TaskExecuter delegate;

    public ResolveTaskOutputCachingStateExecuter(boolean taskOutputCacheEnabled, TaskExecuter delegate) {
        this.taskOutputCacheEnabled = taskOutputCacheEnabled;
        this.delegate = delegate;
    }

    @Override
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        if (this.taskOutputCacheEnabled) {
            TaskOutputCachingState taskOutputCachingState = task.getOutputs().getCachingState(context.getTaskProperties(), context.getBuildCacheKey());
            state.setTaskOutputCaching(taskOutputCachingState);
            if (!taskOutputCachingState.isEnabled()) {
                LOGGER.info("Caching disabled for {}: {}", (Object)task, (Object)taskOutputCachingState.getDisabledReason());
            }
        } else {
            state.setTaskOutputCaching(DefaultTaskOutputs.DISABLED);
        }
        this.delegate.execute(task, state, context);
    }
}

