/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.InputsCache;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020!J\u001b\u0010#\u001a\u00020\u001f\"\b\b\u0001\u0010$*\u00020\u000b*\u0002H$H\u0004\u00a2\u0006\u0002\u0010%R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;", "PlatformCache", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "", "cachesRootDir", "Ljava/io/File;", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/ICReporter;)V", "caches", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "Lkotlin/collections/ArrayList;", "getCachesRootDir", "()Ljava/io/File;", "inputSnapshotsCacheDir", "inputsCache", "Lorg/jetbrains/kotlin/incremental/InputsCache;", "getInputsCache", "()Lorg/jetbrains/kotlin/incremental/InputsCache;", "lookupCache", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "getLookupCache", "()Lorg/jetbrains/kotlin/incremental/LookupStorage;", "lookupCacheDir", "platformCache", "getPlatformCache", "()Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "getReporter", "()Lorg/jetbrains/kotlin/incremental/ICReporter;", "clean", "", "close", "", "flush", "registerCache", "T", "(Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;)V", "incremental-compilation-impl"})
public abstract class IncrementalCachesManager<PlatformCache extends AbstractIncrementalCache<?>> {
    private final ArrayList<BasicMapsOwner> caches;
    private final File inputSnapshotsCacheDir;
    private final File lookupCacheDir;
    @NotNull
    private final InputsCache inputsCache;
    @NotNull
    private final LookupStorage lookupCache;
    @NotNull
    private final File cachesRootDir;
    @NotNull
    private final ICReporter reporter;

    protected final <T extends BasicMapsOwner> void registerCache(@NotNull T $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        this.caches.add($receiver);
    }

    @NotNull
    public final InputsCache getInputsCache() {
        return this.inputsCache;
    }

    @NotNull
    public final LookupStorage getLookupCache() {
        return this.lookupCache;
    }

    @NotNull
    public abstract PlatformCache getPlatformCache();

    public final void clean() {
        Iterable $receiver$iv = this.caches;
        for (Object element$iv : $receiver$iv) {
            BasicMapsOwner it = (BasicMapsOwner)element$iv;
            it.clean();
        }
        FilesKt.deleteRecursively((File)this.cachesRootDir);
    }

    public final boolean close(boolean flush2) {
        boolean successful = true;
        for (BasicMapsOwner cache2 : this.caches) {
            if (flush2) {
                try {
                    cache2.flush(false);
                }
                catch (Throwable e) {
                    successful = false;
                    this.reporter.report((Function0<String>)((Function0)new Function0<String>(cache2, e){
                        final /* synthetic */ BasicMapsOwner $cache;
                        final /* synthetic */ Throwable $e;

                        @NotNull
                        public final String invoke() {
                            return "Exception when flushing cache " + this.$cache.getClass() + ": " + this.$e;
                        }
                        {
                            this.$cache = basicMapsOwner;
                            this.$e = throwable;
                            super(0);
                        }
                    }));
                }
            }
            try {
                cache2.close();
            }
            catch (Throwable e) {
                successful = false;
                this.reporter.report((Function0<String>)((Function0)new Function0<String>(cache2, e){
                    final /* synthetic */ BasicMapsOwner $cache;
                    final /* synthetic */ Throwable $e;

                    @NotNull
                    public final String invoke() {
                        return "Exception when closing cache " + this.$cache.getClass() + ": " + this.$e;
                    }
                    {
                        this.$cache = basicMapsOwner;
                        this.$e = throwable;
                        super(0);
                    }
                }));
            }
        }
        return successful;
    }

    public static /* synthetic */ boolean close$default(IncrementalCachesManager incrementalCachesManager, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: close");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return incrementalCachesManager.close(bl);
    }

    @NotNull
    protected final File getCachesRootDir() {
        return this.cachesRootDir;
    }

    @NotNull
    protected final ICReporter getReporter() {
        return this.reporter;
    }

    public IncrementalCachesManager(@NotNull File cachesRootDir, @NotNull ICReporter reporter) {
        Intrinsics.checkParameterIsNotNull((Object)cachesRootDir, (String)"cachesRootDir");
        Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
        this.cachesRootDir = cachesRootDir;
        this.reporter = reporter;
        IncrementalCachesManager incrementalCachesManager = this;
        Object object = new ArrayList();
        incrementalCachesManager.caches = object;
        Object object2 = new File(this.cachesRootDir, "inputs");
        incrementalCachesManager = this;
        Object $receiver = object2;
        ((File)$receiver).mkdirs();
        object = object2;
        incrementalCachesManager.inputSnapshotsCacheDir = object;
        object2 = new File(this.cachesRootDir, "lookups");
        incrementalCachesManager = this;
        $receiver = object2;
        ((File)$receiver).mkdirs();
        object = object2;
        incrementalCachesManager.lookupCacheDir = object;
        object2 = new InputsCache(this.inputSnapshotsCacheDir, this.reporter);
        incrementalCachesManager = this;
        $receiver = object2;
        this.registerCache((BasicMapsOwner)$receiver);
        incrementalCachesManager.inputsCache = object = object2;
        object2 = new LookupStorage(this.lookupCacheDir);
        incrementalCachesManager = this;
        $receiver = object2;
        this.registerCache((BasicMapsOwner)$receiver);
        incrementalCachesManager.lookupCache = object = object2;
    }
}

