/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.DefaultTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ShortCircuitTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.state.CacheBackedTaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.execution.CatchExceptionTaskExecuter;
import org.gradle.api.internal.tasks.execution.CleanupStaleOutputsExecuter;
import org.gradle.api.internal.tasks.execution.EventFiringTaskExecuter;
import org.gradle.api.internal.tasks.execution.ExecuteActionsTaskExecuter;
import org.gradle.api.internal.tasks.execution.FinalizePropertiesTaskExecuter;
import org.gradle.api.internal.tasks.execution.ResolveBuildCacheKeyExecuter;
import org.gradle.api.internal.tasks.execution.ResolvePreviousStateExecuter;
import org.gradle.api.internal.tasks.execution.ResolveTaskArtifactStateTaskExecuter;
import org.gradle.api.internal.tasks.execution.ResolveTaskOutputCachingStateExecuter;
import org.gradle.api.internal.tasks.execution.SkipEmptySourceFilesTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipOnlyIfTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipTaskWithNoActionsExecuter;
import org.gradle.api.internal.tasks.execution.ValidatingTaskExecuter;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.annotations.FileFingerprintingPropertyAnnotationHandler;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.tasks.TaskCacheKeyCalculator;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.execution.impl.steps.UpToDateResult;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.classpath.ClasspathFingerprinter;
import org.gradle.internal.fingerprint.classpath.impl.DefaultClasspathFingerprinter;
import org.gradle.internal.fingerprint.impl.AbsolutePathFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.DefaultFileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.NameOnlyFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.OutputFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.RelativePathFileCollectionFingerprinter;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.scan.config.BuildScanPluginApplied;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.snapshot.FileSystemSnapshotter;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.normalization.internal.InputNormalizationHandlerInternal;

public class ProjectExecutionServices
extends DefaultServiceRegistry {
    private static final ImmutableList<? extends Class<? extends FileCollectionFingerprinter>> BUILT_IN_FINGERPRINTER_TYPES = ImmutableList.of(AbsolutePathFileCollectionFingerprinter.class, RelativePathFileCollectionFingerprinter.class, NameOnlyFileCollectionFingerprinter.class, IgnoredPathFileCollectionFingerprinter.class, OutputFileCollectionFingerprinter.class);

    public ProjectExecutionServices(ProjectInternal project) {
        super("Configured project services for '" + project.getPath() + "'", new ServiceRegistry[]{project.getServices()});
    }

    TaskActionListener createTaskActionListener(ListenerManager listenerManager) {
        return (TaskActionListener)listenerManager.getBroadcaster(TaskActionListener.class);
    }

    TaskExecuter createTaskExecuter(TaskArtifactStateRepository repository, BuildCacheCommandFactory commandFactory, BuildCacheController buildCacheController, TaskInputsListener inputsListener, TaskActionListener actionListener, OutputChangeListener outputChangeListener, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, BuildOutputCleanupRegistry cleanupRegistry, ExecutionHistoryStore executionHistoryStore, OutputFilesRepository outputFilesRepository, BuildScanPluginApplied buildScanPlugin, PathToFileResolver resolver, PropertyWalker propertyWalker, TaskExecutionGraphInternal taskExecutionGraph, BuildInvocationScopeId buildInvocationScopeId, TaskExecutionListener taskExecutionListener, RelativeFilePathResolver relativeFilePathResolver, WorkExecutor<UpToDateResult> workExecutor) {
        boolean buildCacheEnabled = buildCacheController.isEnabled();
        boolean scanPluginApplied = buildScanPlugin.isBuildScanPluginApplied();
        TaskExecuter executer = new ExecuteActionsTaskExecuter(buildCacheEnabled, buildOperationExecutor, asyncWorkTracker, actionListener, workExecutor);
        executer = new ResolveTaskOutputCachingStateExecuter(buildCacheEnabled, relativeFilePathResolver, executer);
        if (buildCacheEnabled || scanPluginApplied) {
            executer = new ResolveBuildCacheKeyExecuter(executer, buildOperationExecutor, buildCacheController.isEmitDebugLogging());
        }
        executer = new ValidatingTaskExecuter(executer);
        executer = new SkipEmptySourceFilesTaskExecuter(inputsListener, executionHistoryStore, cleanupRegistry, outputChangeListener, executer, buildInvocationScopeId);
        executer = new ResolvePreviousStateExecuter(executionHistoryStore, executer);
        executer = new CleanupStaleOutputsExecuter(cleanupRegistry, outputFilesRepository, buildOperationExecutor, outputChangeListener, executer);
        executer = new FinalizePropertiesTaskExecuter(executer);
        executer = new ResolveTaskArtifactStateTaskExecuter(repository, resolver, propertyWalker, executer);
        executer = new SkipTaskWithNoActionsExecuter(taskExecutionGraph, executer);
        executer = new SkipOnlyIfTaskExecuter(executer);
        executer = new CatchExceptionTaskExecuter(executer);
        executer = new EventFiringTaskExecuter(buildOperationExecutor, taskExecutionListener, executer);
        return executer;
    }

    ClasspathFingerprinter createClasspathFingerprinter(ResourceSnapshotterCacheService resourceSnapshotterCacheService, FileSystemSnapshotter fileSystemSnapshotter, StringInterner stringInterner, InputNormalizationHandlerInternal inputNormalizationHandler) {
        return new DefaultClasspathFingerprinter(resourceSnapshotterCacheService, fileSystemSnapshotter, inputNormalizationHandler.getRuntimeClasspath().getResourceFilter(), stringInterner);
    }

    FileCollectionFingerprinterRegistry createFileCollectionFingerprinterRegistry(ServiceRegistry serviceRegistry, List<FileFingerprintingPropertyAnnotationHandler> handlers) {
        ImmutableList.Builder fingerprinterImplementations = ImmutableList.builder();
        for (Class builtInFingerprinterType : BUILT_IN_FINGERPRINTER_TYPES) {
            fingerprinterImplementations.add(serviceRegistry.get(builtInFingerprinterType));
        }
        for (FileFingerprintingPropertyAnnotationHandler handler : handlers) {
            fingerprinterImplementations.add(serviceRegistry.get(handler.getFingerprinterImplementationType()));
        }
        return new DefaultFileCollectionFingerprinterRegistry((Collection)fingerprinterImplementations.build());
    }

    TaskHistoryRepository createTaskHistoryRepository(ExecutionHistoryStore executionHistoryStore, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ValueSnapshotter valueSnapshotter, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        return new CacheBackedTaskHistoryRepository(executionHistoryStore, classLoaderHierarchyHasher, valueSnapshotter, fingerprinterRegistry);
    }

    TaskArtifactStateRepository createTaskArtifactStateRepository(Instantiator instantiator, StartParameter startParameter, TaskHistoryRepository taskHistoryRepository, OutputFilesRepository taskOutputsRepository, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        TaskCacheKeyCalculator taskCacheKeyCalculator = new TaskCacheKeyCalculator(startParameter.isBuildCacheDebugLogging());
        return new ShortCircuitTaskArtifactStateRepository(startParameter, instantiator, new DefaultTaskArtifactStateRepository(fingerprinterRegistry, taskHistoryRepository, instantiator, taskOutputsRepository, taskCacheKeyCalculator));
    }
}

