/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.command;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.command.BuildCacheLoadListener;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.UnrecoverableUnpackingException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.nativeintegration.filesystem.DefaultFileMetadata;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemMirror;
import org.gradle.internal.snapshot.MissingFileSnapshot;

public class BuildCacheCommandFactory {
    private static final Logger LOGGER = Logging.getLogger(BuildCacheCommandFactory.class);
    private final BuildCacheEntryPacker packer;
    private final OriginMetadataFactory originMetadataFactory;
    private final FileSystemMirror fileSystemMirror;
    private final StringInterner stringInterner;

    public BuildCacheCommandFactory(BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, FileSystemMirror fileSystemMirror, StringInterner stringInterner) {
        this.packer = packer;
        this.originMetadataFactory = originMetadataFactory;
        this.fileSystemMirror = fileSystemMirror;
        this.stringInterner = stringInterner;
    }

    public BuildCacheLoadCommand<LoadMetadata> createLoad(BuildCacheKey cacheKey, CacheableEntity entity, Iterable<File> localState, BuildCacheLoadListener loadListener) {
        return new LoadCommand(cacheKey, entity, localState, loadListener);
    }

    public BuildCacheStoreCommand createStore(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, long executionTime) {
        return new StoreCommand(cacheKey, entity, fingerprints, executionTime);
    }

    private class StoreCommand
    implements BuildCacheStoreCommand {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;
        private final Map<String, CurrentFileCollectionFingerprint> fingerprints;
        private final long executionTime;

        private StoreCommand(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, long executionTime) {
            this.cacheKey = cacheKey;
            this.entity = entity;
            this.fingerprints = fingerprints;
            this.executionTime = executionTime;
        }

        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        public BuildCacheStoreCommand.Result store(OutputStream output) throws IOException {
            LOGGER.info("Packing {}", (Object)this.entity.getDisplayName());
            final BuildCacheEntryPacker.PackResult packResult = BuildCacheCommandFactory.this.packer.pack(this.entity, this.fingerprints, output, BuildCacheCommandFactory.this.originMetadataFactory.createWriter(this.entity, this.executionTime));
            return new BuildCacheStoreCommand.Result(){

                public long getArtifactEntryCount() {
                    return packResult.getEntries();
                }
            };
        }
    }

    private class LoadCommand
    implements BuildCacheLoadCommand<LoadMetadata> {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;
        private final Iterable<File> localState;
        private final BuildCacheLoadListener loadListener;

        private LoadCommand(BuildCacheKey cacheKey, CacheableEntity entity, Iterable<File> localState, BuildCacheLoadListener loadListener) {
            this.cacheKey = cacheKey;
            this.entity = entity;
            this.localState = localState;
            this.loadListener = loadListener;
        }

        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        public BuildCacheLoadCommand.Result<LoadMetadata> load(InputStream input) {
            this.loadListener.beforeLoad();
            try {
                final BuildCacheEntryPacker.UnpackResult unpackResult = BuildCacheCommandFactory.this.packer.unpack(this.entity, input, BuildCacheCommandFactory.this.originMetadataFactory.createReader(this.entity));
                final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshots = this.snapshotUnpackedData(unpackResult.getSnapshots());
                LOGGER.info("Unpacked trees for {} from cache.", (Object)this.entity.getDisplayName());
                BuildCacheLoadCommand.Result<LoadMetadata> result = new BuildCacheLoadCommand.Result<LoadMetadata>(){

                    public long getArtifactEntryCount() {
                        return unpackResult.getEntries();
                    }

                    public LoadMetadata getMetadata() {
                        return new LoadMetadata(){

                            @Override
                            public OriginMetadata getOriginMetadata() {
                                return unpackResult.getOriginMetadata();
                            }

                            @Override
                            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getResultingSnapshots() {
                                return snapshots;
                            }
                        };
                    }
                };
                return result;
            }
            catch (Exception e) {
                LOGGER.warn("Cleaning {} after failed load from cache.", (Object)this.entity.getDisplayName());
                try {
                    this.cleanupTreesAfterUnpackFailure();
                    this.loadListener.afterLoadFailedAndWasCleanedUp(e);
                }
                catch (Exception eCleanup) {
                    LOGGER.warn("Unrecoverable error during cleaning up after unpack failure", (Throwable)eCleanup);
                    throw new UnrecoverableUnpackingException(String.format("Failed to unpack trees for %s, and then failed to clean up; see log above for details", this.entity.getDisplayName()), e);
                }
                throw new GradleException(String.format("Failed to unpack trees for %s", this.entity.getDisplayName()), (Throwable)e);
            }
            finally {
                this.cleanLocalState();
            }
        }

        private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotUnpackedData(Map<String, ? extends FileSystemLocationSnapshot> treeSnapshots) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            FingerprintingStrategy fingerprintingStrategy = AbsolutePathFingerprintingStrategy.IGNORE_MISSING;
            this.entity.visitTrees((treeName, type, root) -> {
                if (root == null) {
                    builder.put((Object)treeName, (Object)fingerprintingStrategy.getEmptyFingerprint());
                    return;
                }
                FileSystemLocationSnapshot treeSnapshot = (FileSystemLocationSnapshot)treeSnapshots.get(treeName);
                String internedAbsolutePath = BuildCacheCommandFactory.this.stringInterner.intern(root.getAbsolutePath());
                ArrayList<FileSystemLocationSnapshot> roots = new ArrayList<FileSystemLocationSnapshot>();
                if (treeSnapshot == null) {
                    BuildCacheCommandFactory.this.fileSystemMirror.putMetadata(internedAbsolutePath, DefaultFileMetadata.missing());
                    BuildCacheCommandFactory.this.fileSystemMirror.putSnapshot((FileSystemLocationSnapshot)new MissingFileSnapshot(internedAbsolutePath, root.getName()));
                    builder.put((Object)treeName, (Object)fingerprintingStrategy.getEmptyFingerprint());
                    return;
                }
                switch (type) {
                    case FILE: {
                        if (treeSnapshot.getType() != FileType.RegularFile) {
                            throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking tree '%s', but saw a %s", treeName, treeSnapshot.getType()));
                        }
                        roots.add(treeSnapshot);
                        BuildCacheCommandFactory.this.fileSystemMirror.putSnapshot(treeSnapshot);
                        break;
                    }
                    case DIRECTORY: {
                        roots.add(treeSnapshot);
                        BuildCacheCommandFactory.this.fileSystemMirror.putMetadata(internedAbsolutePath, DefaultFileMetadata.directory());
                        BuildCacheCommandFactory.this.fileSystemMirror.putSnapshot(treeSnapshot);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                builder.put((Object)treeName, (Object)DefaultCurrentFileCollectionFingerprint.from(roots, (FingerprintingStrategy)fingerprintingStrategy));
            });
            return builder.build();
        }

        private void cleanLocalState() {
            for (File localStateFile : this.localState) {
                try {
                    this.remove(localStateFile);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up local state files for %s: %s", this.entity.getDisplayName(), localStateFile), (Throwable)ex);
                }
            }
        }

        private void cleanupTreesAfterUnpackFailure() {
            this.entity.visitTrees((name, type, root) -> {
                try {
                    this.remove(root);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up files for tree '%s' of %s: %s", name, this.entity.getDisplayName(), root), (Throwable)ex);
                }
            });
        }

        private void remove(File file) throws IOException {
            if (file != null && file.exists()) {
                if (file.isDirectory()) {
                    FileUtils.cleanDirectory((File)file);
                } else {
                    FileUtils.forceDelete((File)file);
                }
            }
        }
    }

    public static interface LoadMetadata {
        public OriginMetadata getOriginMetadata();

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getResultingSnapshots();
    }
}

