/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClsStubBuilder;

public class ClassFileDecompilers {
    public static final ExtensionPointName<Decompiler> EP_NAME = ExtensionPointName.create("org.jetbrains.kotlin.com.intellij.psi.classFileDecompiler");

    private ClassFileDecompilers() {
    }

    @Nullable
    public static Decompiler find(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ClassFileDecompilers.$$$reportNull$$$0(0);
        }
        for (Decompiler decompiler : EP_NAME.getExtensions()) {
            if (!(decompiler instanceof Light) && !(decompiler instanceof Full) || !decompiler.accepts(file2)) continue;
            return decompiler;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/compiled/ClassFileDecompilers", "find"));
    }

    public static abstract class Full
    implements Decompiler {
        @NotNull
        public abstract ClsStubBuilder getStubBuilder();

        @NotNull
        public abstract FileViewProvider createFileViewProvider(@NotNull VirtualFile var1, @NotNull PsiManager var2, boolean var3);
    }

    public static abstract class Light
    implements Decompiler {
        @NotNull
        public abstract CharSequence getText(@NotNull VirtualFile var1) throws CannotDecompileException;

        public static class CannotDecompileException
        extends RuntimeException {
            public CannotDecompileException(String message) {
                super(message);
            }

            public CannotDecompileException(Throwable cause) {
                super(cause);
            }
        }
    }

    public static interface Decompiler {
        public boolean accepts(@NotNull VirtualFile var1);
    }
}

