/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.taskfactory.DefaultTaskClassInfoStore;
import org.gradle.api.internal.tasks.properties.AbstractPropertyNode;
import org.gradle.api.internal.tasks.properties.DefaultPropertyMetadataStore;
import org.gradle.api.internal.tasks.properties.PropertyMetadata;
import org.gradle.api.internal.tasks.properties.PropertyMetadataStore;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.annotations.ClasspathPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.CompileClasspathPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.cache.internal.DefaultCrossBuildInMemoryCacheFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ListenerManager;

@NonNullApi
public class PropertyValidationAccess {
    private static final Map<Class<? extends Annotation>, PropertyValidator> PROPERTY_VALIDATORS = ImmutableMap.of(Input.class, (Object)new InputOnFileTypeValidator(), InputFiles.class, (Object)new MissingPathSensitivityValidator(), InputFile.class, (Object)new MissingPathSensitivityValidator(), InputDirectory.class, (Object)new MissingPathSensitivityValidator());

    public static void collectTaskValidationProblems(Class<?> topLevelBean, Map<String, Boolean> problems, boolean enableStricterValidation) {
        boolean stricterValidation;
        DefaultCrossBuildInMemoryCacheFactory cacheFactory = new DefaultCrossBuildInMemoryCacheFactory((ListenerManager)new DefaultListenerManager());
        DefaultTaskClassInfoStore taskClassInfoStore = new DefaultTaskClassInfoStore(cacheFactory);
        DefaultPropertyMetadataStore metadataStore = new DefaultPropertyMetadataStore((Iterable<? extends PropertyAnnotationHandler>)ImmutableList.of((Object)new ClasspathPropertyAnnotationHandler(), (Object)new CompileClasspathPropertyAnnotationHandler()), cacheFactory);
        ArrayDeque queue = new ArrayDeque();
        BeanTypeNodeFactory nodeFactory = new BeanTypeNodeFactory(metadataStore);
        queue.add(nodeFactory.createRootNode(TypeToken.of(topLevelBean)));
        boolean cacheable = taskClassInfoStore.getTaskClassInfo((Class)Cast.uncheckedCast(topLevelBean)).isCacheable();
        boolean bl = stricterValidation = enableStricterValidation || cacheable;
        while (!queue.isEmpty()) {
            BeanTypeNode node = (BeanTypeNode)queue.remove();
            node.visit(topLevelBean, stricterValidation, problems, queue, nodeFactory);
        }
    }

    private static <T> TypeToken<?> extractNestedType(TypeToken<T> beanType, Class<? super T> parameterizedSuperClass, int typeParameterIndex) {
        ParameterizedType type = (ParameterizedType)beanType.getSupertype(parameterizedSuperClass).getType();
        return TypeToken.of((Type)type.getActualTypeArguments()[typeParameterIndex]);
    }

    private static class MissingPathSensitivityValidator
    implements PropertyValidator {
        private MissingPathSensitivityValidator() {
        }

        @Override
        @Nullable
        public String validate(boolean stricterValidation, PropertyMetadata metadata) {
            PathSensitive pathSensitive = metadata.getAnnotation(PathSensitive.class);
            if (stricterValidation && pathSensitive == null) {
                return "is missing a @PathSensitive annotation, defaulting to PathSensitivity.ABSOLUTE";
            }
            return null;
        }
    }

    private static class InputOnFileTypeValidator
    implements PropertyValidator {
        private InputOnFileTypeValidator() {
        }

        @Override
        @Nullable
        public String validate(boolean stricterValidation, PropertyMetadata metadata) {
            Class<?> valueType = metadata.getDeclaredType();
            if (File.class.isAssignableFrom(valueType) || Path.class.isAssignableFrom(valueType) || FileCollection.class.isAssignableFrom(valueType)) {
                return "has @Input annotation used on property of type " + valueType.getName();
            }
            return null;
        }
    }

    private static interface PropertyValidator {
        @Nullable
        public String validate(boolean var1, PropertyMetadata var2);
    }

    private static class MapBeanTypeNode
    extends BeanTypeNode<Map<?, ?>> {
        public MapBeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String parentPropertyName, TypeToken<Map<?, ?>> mapType, TypeMetadata typeMetadata) {
            super(parentNode, parentPropertyName, mapType, typeMetadata);
        }

        @Override
        public void visit(Class<?> topLevelBean, boolean stricterValidation, Map<String, Boolean> problems, Queue<BeanTypeNode<?>> queue, BeanTypeNodeFactory nodeFactory) {
            TypeToken<?> nestedType = this.extractNestedType(Map.class, 1);
            nodeFactory.createAndAddToQueue(this, this.getQualifiedPropertyName("<key>"), nestedType, queue);
        }
    }

    private static class IterableBeanTypeNode
    extends BeanTypeNode<Iterable<?>> {
        public IterableBeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String parentPropertyName, TypeToken<Iterable<?>> iterableType, TypeMetadata typeMetadata) {
            super(parentNode, parentPropertyName, iterableType, typeMetadata);
        }

        private String determinePropertyName(TypeToken<?> nestedType) {
            return Named.class.isAssignableFrom(nestedType.getRawType()) ? this.getQualifiedPropertyName("<name>") : this.getPropertyName() + "*";
        }

        @Override
        public void visit(Class<?> topLevelBean, boolean stricterValidation, Map<String, Boolean> problems, Queue<BeanTypeNode<?>> queue, BeanTypeNodeFactory nodeFactory) {
            TypeToken<?> nestedType = this.extractNestedType(Iterable.class, 0);
            nodeFactory.createAndAddToQueue(this, this.determinePropertyName(nestedType), nestedType, queue);
        }
    }

    private static class NestedBeanTypeNode
    extends BeanTypeNode<Object> {
        public NestedBeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String parentPropertyName, TypeToken<?> beanType, TypeMetadata typeMetadata) {
            super(parentNode, parentPropertyName, beanType, typeMetadata);
        }

        @Override
        public void visit(Class<?> topLevelBean, boolean stricterValidation, Map<String, Boolean> problems, Queue<BeanTypeNode<?>> queue, BeanTypeNodeFactory nodeFactory) {
            for (PropertyMetadata metadata : this.getTypeMetadata().getPropertiesMetadata()) {
                String validationMessage;
                String qualifiedPropertyName = this.getQualifiedPropertyName(metadata.getFieldName());
                for (String validationMessage2 : metadata.getValidationMessages()) {
                    problems.put(NestedBeanTypeNode.propertyValidationMessage(topLevelBean, qualifiedPropertyName, validationMessage2), Boolean.FALSE);
                }
                Class<? extends Annotation> propertyType = metadata.getPropertyType();
                if (propertyType == null) {
                    if (Modifier.isPrivate(metadata.getMethod().getModifiers())) continue;
                    problems.put(NestedBeanTypeNode.propertyValidationMessage(topLevelBean, qualifiedPropertyName, "is not annotated with an input or output annotation"), Boolean.FALSE);
                    continue;
                }
                PropertyValidator validator = (PropertyValidator)PROPERTY_VALIDATORS.get(propertyType);
                if (validator != null && (validationMessage = validator.validate(stricterValidation, metadata)) != null) {
                    problems.put(NestedBeanTypeNode.propertyValidationMessage(topLevelBean, qualifiedPropertyName, validationMessage), Boolean.FALSE);
                }
                if (!metadata.isAnnotationPresent(Nested.class)) continue;
                TypeToken<?> beanType = NestedBeanTypeNode.unpackProvider(metadata.getMethod());
                nodeFactory.createAndAddToQueue(this, qualifiedPropertyName, beanType, queue);
            }
        }

        private static TypeToken<?> unpackProvider(Method method) {
            Class<?> rawType = method.getReturnType();
            TypeToken genericReturnType = TypeToken.of((Type)method.getGenericReturnType());
            if (Provider.class.isAssignableFrom(rawType)) {
                return PropertyValidationAccess.extractNestedType((TypeToken)Cast.uncheckedCast((Object)genericReturnType), Provider.class, 0);
            }
            return genericReturnType;
        }

        private static String propertyValidationMessage(Class<?> task, String qualifiedPropertyName, String validationMessage) {
            return String.format("Task type '%s': property '%s' %s.", task.getName(), qualifiedPropertyName, validationMessage);
        }
    }

    private static abstract class BeanTypeNode<T>
    extends AbstractPropertyNode<TypeToken<?>> {
        private final TypeToken<? extends T> beanType;

        protected BeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String propertyName, TypeToken<? extends T> beanType, TypeMetadata typeMetadata) {
            super(parentNode, propertyName, typeMetadata);
            this.beanType = beanType;
        }

        public abstract void visit(Class<?> var1, boolean var2, Map<String, Boolean> var3, Queue<BeanTypeNode<?>> var4, BeanTypeNodeFactory var5);

        public boolean nodeCreatesCycle(TypeToken<?> childType) {
            return this.findNodeCreatingCycle(childType, Equivalence.equals()) != null;
        }

        protected TypeToken<?> extractNestedType(Class<? super T> parameterizedSuperClass, int typeParameterIndex) {
            return PropertyValidationAccess.extractNestedType(this.beanType, parameterizedSuperClass, typeParameterIndex);
        }

        @Override
        protected TypeToken<?> getNodeValue() {
            return this.beanType;
        }
    }

    private static class BeanTypeNodeFactory {
        private final PropertyMetadataStore metadataStore;

        public BeanTypeNodeFactory(PropertyMetadataStore metadataStore) {
            this.metadataStore = metadataStore;
        }

        public BeanTypeNode<?> createRootNode(TypeToken<?> beanType) {
            return new NestedBeanTypeNode(null, null, beanType, this.metadataStore.getTypeMetadata(beanType.getRawType()));
        }

        public void createAndAddToQueue(BeanTypeNode<?> parentNode, String propertyName, TypeToken<?> beanType, Queue<BeanTypeNode<?>> queue) {
            if (!parentNode.nodeCreatesCycle(beanType)) {
                queue.add(this.createChild(parentNode, propertyName, beanType));
            }
        }

        private BeanTypeNode<?> createChild(BeanTypeNode<?> parentNode, String propertyName, TypeToken<?> beanType) {
            Class rawType = beanType.getRawType();
            TypeMetadata typeMetadata = this.metadataStore.getTypeMetadata(rawType);
            if (!typeMetadata.hasAnnotatedProperties()) {
                if (Map.class.isAssignableFrom(rawType)) {
                    return new MapBeanTypeNode(parentNode, propertyName, (TypeToken<Map<?, ?>>)((TypeToken)Cast.uncheckedCast(beanType)), typeMetadata);
                }
                if (Iterable.class.isAssignableFrom(rawType)) {
                    return new IterableBeanTypeNode(parentNode, propertyName, (TypeToken<Iterable<?>>)((TypeToken)Cast.uncheckedCast(beanType)), typeMetadata);
                }
            }
            return new NestedBeanTypeNode(parentNode, propertyName, beanType, typeMetadata);
        }
    }
}

