/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scan.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.scan.config.BuildScanConfig;
import org.gradle.internal.scan.config.BuildScanConfigInit;
import org.gradle.internal.scan.config.BuildScanConfigProvider;
import org.gradle.internal.scan.config.BuildScanPluginApplied;
import org.gradle.internal.scan.config.BuildScanPluginCompatibility;
import org.gradle.internal.scan.config.BuildScanPluginMetadata;
import org.gradle.internal.scan.config.UnsupportedBuildScanPluginVersionException;
import org.gradle.util.VersionNumber;

class BuildScanConfigManager
implements BuildScanConfigInit,
BuildScanConfigProvider,
BuildScanPluginApplied {
    private static final Logger LOGGER = Logging.getLogger(BuildScanConfigManager.class);
    private static final VersionNumber FIRST_VERSION_AWARE_OF_UNSUPPORTED = VersionNumber.parse("1.11");
    private static final String HELP_LINK = "https://gradle.com/scans/help/gradle-cli";
    private static final String SYSPROP_KEY = "scan";
    private static final List<String> ENABLED_SYS_PROP_VALUES = Arrays.asList(null, "", "yes", "true");
    private final StartParameter startParameter;
    private final ListenerManager listenerManager;
    private final BuildScanPluginCompatibility compatibility;
    private final Factory<BuildScanConfig.Attributes> configAttributes;
    private Requestedness requestedness = Requestedness.DEFAULTED;
    private boolean collected;

    BuildScanConfigManager(StartParameter startParameter, ListenerManager listenerManager, BuildScanPluginCompatibility compatibility, Factory<BuildScanConfig.Attributes> configAttributes) {
        this.startParameter = startParameter;
        this.listenerManager = listenerManager;
        this.compatibility = compatibility;
        this.configAttributes = configAttributes;
    }

    @Override
    public void init() {
        boolean checkForPlugin = false;
        if (this.startParameter.isBuildScan()) {
            checkForPlugin = true;
            this.requestedness = Requestedness.ENABLED;
        } else if (this.startParameter.isNoBuildScan()) {
            this.requestedness = Requestedness.DISABLED;
        } else {
            Map sysProps = this.startParameter.getSystemPropertiesArgs();
            if (sysProps.containsKey(SYSPROP_KEY)) {
                String sysProp = (String)sysProps.get(SYSPROP_KEY);
                checkForPlugin = ENABLED_SYS_PROP_VALUES.contains(sysProp);
            }
        }
        if (checkForPlugin) {
            this.warnIfBuildScanPluginNotApplied();
        }
    }

    private void warnIfBuildScanPluginNotApplied() {
        this.listenerManager.addListener((Object)new InternalBuildAdapter(){

            public void projectsEvaluated(Gradle gradle) {
                if (gradle.getParent() == null && !BuildScanConfigManager.this.collected) {
                    LOGGER.warn("Build scan cannot be created because the build scan plugin was not applied.\nFor more information on how to apply the build scan plugin, please visit https://gradle.com/scans/help/gradle-cli.");
                }
            }
        });
    }

    @Override
    public BuildScanConfig collect(BuildScanPluginMetadata pluginMetadata) {
        if (this.collected) {
            throw new IllegalStateException("Configuration has already been collected.");
        }
        this.collected = true;
        BuildScanConfig.Attributes configAttributes = (BuildScanConfig.Attributes)this.configAttributes.create();
        VersionNumber pluginVersion = VersionNumber.parse(pluginMetadata.getVersion()).getBaseVersion();
        String unsupportedReason = this.compatibility.unsupportedReason(pluginVersion);
        if (unsupportedReason != null) {
            if (this.isPluginAwareOfUnsupported(pluginVersion)) {
                return this.requestedness.toConfig(unsupportedReason, configAttributes);
            }
            throw new UnsupportedBuildScanPluginVersionException(unsupportedReason);
        }
        return this.requestedness.toConfig(null, configAttributes);
    }

    private boolean isPluginAwareOfUnsupported(VersionNumber pluginVersion) {
        return pluginVersion.compareTo(FIRST_VERSION_AWARE_OF_UNSUPPORTED) >= 0;
    }

    @Override
    public boolean isBuildScanPluginApplied() {
        return this.collected;
    }

    private static enum Requestedness {
        DEFAULTED(false, false),
        ENABLED(true, false),
        DISABLED(false, true);

        private final boolean enabled;
        private final boolean disabled;

        private Requestedness(boolean enabled, boolean disabled) {
            this.enabled = enabled;
            this.disabled = disabled;
        }

        BuildScanConfig toConfig(final String unsupported, final BuildScanConfig.Attributes attributes) {
            return new BuildScanConfig(){

                @Override
                public boolean isEnabled() {
                    return Requestedness.this.enabled;
                }

                @Override
                public boolean isDisabled() {
                    return Requestedness.this.disabled;
                }

                @Override
                public String getUnsupportedMessage() {
                    return unsupported;
                }

                @Override
                public BuildScanConfig.Attributes getAttributes() {
                    return attributes;
                }
            };
        }
    }
}

