/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.JsEqualsHashcodeToStringGenerator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

class JsDataClassGenerator
extends JsEqualsHashcodeToStringGenerator {
    JsDataClassGenerator(KtClassOrObject klass2, TranslationContext context) {
        super(klass2, context);
    }

    @Override
    public void generateComponentFunction(@NotNull FunctionDescriptor function2, @NotNull ValueParameterDescriptor parameter) {
        PropertyDescriptor propertyDescriptor = this.context.bindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter);
        assert (propertyDescriptor != null) : "Property descriptor is expected to be non-null";
        JsFunction functionObject = this.generateJsMethod(function2);
        JsNameRef returnExpression = JsAstUtils.pureFqn(this.context.getNameForDescriptor(propertyDescriptor), (JsExpression)new JsThisRef());
        JsReturn returnStatement = new JsReturn(returnExpression);
        returnStatement.setSource(KotlinSourceElementKt.getPsi(parameter.getSource()));
        functionObject.getBody().getStatements().add(returnStatement);
    }

    @Override
    public void generateCopyFunction(@NotNull FunctionDescriptor function2, @NotNull List<? extends KtParameter> constructorParameters) {
        JsFunction functionObj = this.generateJsMethod(function2);
        assert (function2.getValueParameters().size() == constructorParameters.size());
        ArrayList<JsExpression> constructorArguments = new ArrayList<JsExpression>(constructorParameters.size());
        for (int i = 0; i < constructorParameters.size(); ++i) {
            JsExpression argumentValue;
            KtParameter constructorParam = constructorParameters.get(i);
            ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)BindingContextUtils.getNotNull(this.context.bindingContext(), BindingContext.VALUE_PARAMETER, constructorParam);
            PropertyDescriptor propertyDescriptor = BindingContextUtils.getNotNull(this.context.bindingContext(), BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor);
            JsName fieldName = this.context.getNameForDescriptor(propertyDescriptor);
            JsName paramName = JsScope.declareTemporaryName(this.context.getNameForDescriptor(parameterDescriptor).getIdent());
            functionObj.getParameters().add(new JsParameter(paramName));
            JsNameRef parameterValue = new JsNameRef(paramName);
            if (!constructorParam.hasValOrVar()) {
                assert (!ArgumentsUtilsKt.hasDefaultValue(function2.getValueParameters().get(i)));
                argumentValue = parameterValue;
            } else {
                JsBinaryOperation defaultCondition = JsAstUtils.equality(new JsNameRef(paramName), Namer.getUndefinedExpression());
                argumentValue = new JsConditional(defaultCondition, new JsNameRef(fieldName, (JsExpression)new JsThisRef()), parameterValue);
            }
            constructorArguments.add(argumentValue.source(constructorParam));
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)function2.getContainingDeclaration();
        ClassConstructorDescriptor constructor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
        assert (constructor != null) : "Data class should have primary constructor: " + classDescriptor2;
        JsExpression constructorRef = this.context.getInnerReference(constructor);
        JsNew returnExpression = new JsNew(constructorRef, constructorArguments);
        if (this.context.shouldBeDeferred(constructor)) {
            this.context.deferConstructorCall(constructor, returnExpression.getArguments());
        }
        returnExpression.setSource(this.getDeclaration());
        JsReturn returnStatement = new JsReturn(returnExpression);
        returnStatement.setSource(this.getDeclaration());
        functionObj.getBody().getStatements().add(returnStatement);
    }
}

