/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.PublishableComponent;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.language.ComponentWithBinaries;
import org.gradle.language.ComponentWithOutputs;
import org.gradle.language.ProductionComponent;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithExecutable;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithRuntimeUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithSharedLibrary;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithStaticLibrary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.tasks.ExtractSymbols;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.tasks.StripSymbols;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public class NativeBasePlugin
implements Plugin<ProjectInternal> {
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public NativeBasePlugin(TargetMachineFactory targetMachineFactory) {
        this.targetMachineFactory = targetMachineFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        NativeBasePlugin.addTargetMachineFactoryAsExtension((ExtensionContainer)project.getExtensions(), this.targetMachineFactory);
        TaskContainerInternal tasks = project.getTasks();
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        SoftwareComponentContainer components = project.getComponents();
        this.addLifecycleTasks((TaskContainer)tasks, components);
        this.addTasksForComponentWithExecutable((TaskContainer)tasks, buildDirectory, components);
        this.addTasksForComponentWithSharedLibrary((TaskContainer)tasks, buildDirectory, components);
        this.addTasksForComponentWithStaticLibrary((TaskContainer)tasks, buildDirectory, components);
        ConfigurationContainer configurations = project.getConfigurations();
        project.getDependencies().getAttributesSchema().attribute(CppBinary.LINKAGE_ATTRIBUTE).getDisambiguationRules().add(LinkageSelectionRule.class);
        this.addOutgoingConfigurationForLinkUsage(components, configurations);
        this.addOutgoingConfigurationForRuntimeUsage(components, configurations);
        this.addPublicationsFromVariants(project, components);
    }

    private static void addTargetMachineFactoryAsExtension(ExtensionContainer extensions, TargetMachineFactory targetMachineFactory) {
        extensions.add(TargetMachineFactory.class, "machines", (Object)targetMachineFactory);
    }

    private void addLifecycleTasks(TaskContainer tasks, SoftwareComponentContainer components) {
        components.withType(ComponentWithBinaries.class, component -> {
            component.getBinaries().whenElementKnown((Action<? extends SoftwareComponent>)((Action)binary -> components.add(binary)));
            if (component instanceof ProductionComponent) {
                component.getBinaries().whenElementFinalized(ComponentWithOutputs.class, binary -> {
                    FileCollection outputs = binary.getOutputs();
                    Names names = ((ComponentWithNames)((Object)binary)).getNames();
                    tasks.register(names.getTaskName("assemble"), task -> task.dependsOn(new Object[]{outputs}));
                    if (binary == ((ProductionComponent)((Object)component)).getDevelopmentBinary().get()) {
                        tasks.named("assemble", task -> task.dependsOn(new Object[]{outputs}));
                    }
                });
            }
        });
    }

    private void addTasksForComponentWithExecutable(TaskContainer tasks, DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithExecutable.class, executable -> {
            Names names = executable.getNames();
            NativeToolChain toolChain = executable.getToolChain();
            NativePlatform targetPlatform = executable.getTargetPlatform();
            PlatformToolProvider toolProvider = executable.getPlatformToolProvider();
            TaskProvider link = tasks.register(names.getTaskName("link"), LinkExecutable.class, task -> {
                task.source((Object)executable.getObjects());
                task.lib((Object)executable.getLinkLibraries());
                task.getLinkedFile().set(buildDirectory.file(executable.getBaseName().map(baseName -> toolProvider.getExecutableName("exe/" + names.getDirName() + baseName))));
                task.getTargetPlatform().set((Object)targetPlatform);
                task.getToolChain().set((Object)toolChain);
                task.getDebuggable().set((Object)executable.isDebuggable());
            });
            executable.getLinkTask().set((Provider)link);
            executable.getDebuggerExecutableFile().set(link.flatMap(linkExecutable -> linkExecutable.getLinkedFile()));
            if (executable.isDebuggable() && executable.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                Provider symbolLocation = buildDirectory.file(executable.getBaseName().map(baseName -> toolProvider.getExecutableSymbolFileName("exe/" + names.getDirName() + "stripped/" + baseName)));
                Provider strippedLocation = buildDirectory.file(executable.getBaseName().map(baseName -> toolProvider.getExecutableName("exe/" + names.getDirName() + "stripped/" + baseName)));
                TaskProvider<StripSymbols> stripSymbols = this.stripSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, (Provider<RegularFile>)strippedLocation);
                executable.getExecutableFile().set(stripSymbols.flatMap(task -> task.getOutputFile()));
                TaskProvider<ExtractSymbols> extractSymbols = this.extractSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, (Provider<RegularFile>)symbolLocation);
                executable.getOutputs().from(new Object[]{extractSymbols.flatMap(task -> task.getSymbolFile())});
                executable.getExecutableFileProducer().set(stripSymbols);
            } else {
                executable.getExecutableFile().set(link.flatMap(task -> task.getLinkedFile()));
                executable.getExecutableFileProducer().set((Provider)link);
            }
            TaskProvider install = tasks.register(names.getTaskName("install"), InstallExecutable.class, task -> {
                task.getTargetPlatform().set((Object)targetPlatform);
                task.getToolChain().set((Object)toolChain);
                task.getInstallDirectory().set(buildDirectory.dir("install/" + names.getDirName()));
                task.getExecutableFile().set(executable.getExecutableFile());
                task.lib((Object)executable.getRuntimeLibraries());
            });
            executable.getInstallTask().set((Provider)install);
            executable.getInstallDirectory().set(install.flatMap(task -> task.getInstallDirectory()));
            executable.getOutputs().from(new Object[]{executable.getInstallDirectory()});
            executable.getDebuggerExecutableFile().set(install.flatMap(task -> task.getInstalledExecutable()));
        });
    }

    private void addTasksForComponentWithSharedLibrary(TaskContainer tasks, DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithSharedLibrary.class, library -> {
            Names names = library.getNames();
            NativePlatform targetPlatform = library.getTargetPlatform();
            NativeToolChain toolChain = library.getToolChain();
            PlatformToolProvider toolProvider = library.getPlatformToolProvider();
            TaskProvider<StripSymbols> link = tasks.register(names.getTaskName("link"), LinkSharedLibrary.class, task -> {
                task.source((Object)library.getObjects());
                task.lib((Object)library.getLinkLibraries());
                task.getLinkedFile().set(buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getSharedLibraryName("lib/" + names.getDirName() + baseName))));
                if (!targetPlatform.getOperatingSystem().isMacOsX()) {
                    task.getInstallName().set(task.getLinkedFile().map(linkedFile -> linkedFile.getAsFile().getName()));
                }
                task.getTargetPlatform().set((Object)targetPlatform);
                task.getToolChain().set((Object)toolChain);
                task.getDebuggable().set((Object)library.isDebuggable());
            });
            Provider linkFile = link.flatMap(task -> task.getLinkedFile());
            Provider runtimeFile = link.flatMap(task -> task.getLinkedFile());
            TaskProvider<StripSymbols> linkFileTask = link;
            if (toolProvider.producesImportLibrary()) {
                link.configure(linkSharedLibrary -> linkSharedLibrary.getImportLibrary().set(buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getImportLibraryName("lib/" + names.getDirName() + baseName)))));
                linkFile = link.flatMap(task -> task.getImportLibrary());
            }
            if (library.isDebuggable() && library.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                Provider symbolLocation = buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getLibrarySymbolFileName("lib/" + names.getDirName() + "stripped/" + baseName)));
                Provider strippedLocation = buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getSharedLibraryName("lib/" + names.getDirName() + "stripped/" + baseName)));
                TaskProvider<StripSymbols> stripSymbols = this.stripSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, (Provider<RegularFile>)strippedLocation);
                linkFile = runtimeFile = stripSymbols.flatMap(task -> task.getOutputFile());
                TaskProvider<ExtractSymbols> extractSymbols = this.extractSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, (Provider<RegularFile>)symbolLocation);
                library.getOutputs().from(new Object[]{extractSymbols.flatMap(task -> task.getSymbolFile())});
                linkFileTask = stripSymbols;
            }
            library.getLinkTask().set((Provider)link);
            library.getLinkFile().set(linkFile);
            library.getLinkFileProducer().set((Provider)linkFileTask);
            library.getRuntimeFile().set(runtimeFile);
            library.getOutputs().from(new Object[]{library.getLinkFile()});
            library.getOutputs().from(new Object[]{library.getRuntimeFile()});
        });
    }

    private void addTasksForComponentWithStaticLibrary(TaskContainer tasks, DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithStaticLibrary.class, library -> {
            Names names = library.getNames();
            TaskProvider createTask = tasks.register(names.getTaskName("create"), CreateStaticLibrary.class, task -> {
                task.source((Object)library.getObjects());
                PlatformToolProvider toolProvider = library.getPlatformToolProvider();
                Provider linktimeFile = buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getStaticLibraryName("lib/" + names.getDirName() + baseName)));
                task.getOutputFile().set(linktimeFile);
                task.getTargetPlatform().set((Object)library.getTargetPlatform());
                task.getToolChain().set((Object)library.getToolChain());
            });
            library.getLinkFile().set(createTask.flatMap(task -> task.getBinaryFile()));
            library.getLinkFileProducer().set((Provider)createTask);
            library.getCreateTask().set((Provider)createTask);
            library.getOutputs().from(new Object[]{library.getLinkFile()});
        });
    }

    private void addOutgoingConfigurationForLinkUsage(SoftwareComponentContainer components, ConfigurationContainer configurations) {
        components.withType(ConfigurableComponentWithLinkUsage.class, component -> {
            Names names = component.getNames();
            Configuration linkElements = (Configuration)configurations.create(names.withSuffix("linkElements"));
            linkElements.extendsFrom(new Configuration[]{component.getImplementationDependencies()});
            linkElements.setCanBeResolved(false);
            AttributeContainer attributes = component.getLinkAttributes();
            this.copyAttributesTo(attributes, linkElements);
            linkElements.getOutgoing().artifact(component.getLinkFile());
            component.getLinkElements().set((Object)linkElements);
        });
    }

    private void addOutgoingConfigurationForRuntimeUsage(SoftwareComponentContainer components, ConfigurationContainer configurations) {
        components.withType(ConfigurableComponentWithRuntimeUsage.class, component -> {
            Names names = component.getNames();
            Configuration runtimeElements = (Configuration)configurations.create(names.withSuffix("runtimeElements"));
            runtimeElements.extendsFrom(new Configuration[]{component.getImplementationDependencies()});
            runtimeElements.setCanBeResolved(false);
            AttributeContainer attributes = component.getRuntimeAttributes();
            this.copyAttributesTo(attributes, runtimeElements);
            if (component.hasRuntimeFile()) {
                runtimeElements.getOutgoing().artifact(component.getRuntimeFile());
            }
            component.getRuntimeElements().set((Object)runtimeElements);
        });
    }

    private void addPublicationsFromVariants(ProjectInternal project, SoftwareComponentContainer components) {
        project.getPluginManager().withPlugin("maven-publish", plugin -> components.withType(PublicationAwareComponent.class, component -> project.getExtensions().configure(PublishingExtension.class, publishing -> {
            ComponentWithVariants mainVariant = component.getMainPublication();
            publishing.getPublications().create("main", MavenPublication.class, publication -> {
                MavenPublicationInternal publicationInternal = (MavenPublicationInternal)publication;
                publicationInternal.getMavenProjectIdentity().getArtifactId().set(component.getBaseName());
                publicationInternal.from((SoftwareComponent)mainVariant);
                publicationInternal.publishWithOriginalFileName();
            });
            Set variants = mainVariant.getVariants();
            if (variants instanceof DomainObjectSet) {
                ((DomainObjectSet)variants).all(child -> this.addPublicationFromVariant((SoftwareComponent)child, (PublishingExtension)publishing, project));
            } else {
                for (SoftwareComponent variant : variants) {
                    this.addPublicationFromVariant(variant, (PublishingExtension)publishing, project);
                }
            }
        })));
    }

    private void addPublicationFromVariant(SoftwareComponent child, PublishingExtension publishing, ProjectInternal project) {
        if (child instanceof PublishableComponent) {
            publishing.getPublications().create(child.getName(), MavenPublication.class, publication -> {
                MavenPublicationInternal publicationInternal = (MavenPublicationInternal)publication;
                this.fillInCoordinates(project, publicationInternal, (PublishableComponent)child);
                publicationInternal.from(child);
                publicationInternal.publishWithOriginalFileName();
            });
        }
    }

    private void fillInCoordinates(ProjectInternal project, MavenPublicationInternal publication, PublishableComponent publishableComponent) {
        ModuleVersionIdentifier coordinates = publishableComponent.getCoordinates();
        MutableMavenProjectIdentity identity = publication.getMavenProjectIdentity();
        identity.getGroupId().set(project.provider(() -> coordinates.getGroup()));
        identity.getArtifactId().set(project.provider(() -> coordinates.getName()));
        identity.getVersion().set(project.provider(() -> coordinates.getVersion()));
    }

    private void copyAttributesTo(AttributeContainer attributes, Configuration linkElements) {
        for (Attribute attribute : attributes.keySet()) {
            Object value = attributes.getAttribute(attribute);
            linkElements.getAttributes().attribute((Attribute)Cast.uncheckedCast((Object)attribute), value);
        }
    }

    private TaskProvider<StripSymbols> stripSymbols(TaskProvider<? extends AbstractLinkTask> link, Names names, TaskContainer tasks, NativeToolChain toolChain, NativePlatform currentPlatform, Provider<RegularFile> strippedLocation) {
        return tasks.register(names.getTaskName("stripSymbols"), StripSymbols.class, stripSymbols -> {
            stripSymbols.getBinaryFile().set(link.flatMap(task -> task.getLinkedFile()));
            stripSymbols.getOutputFile().set(strippedLocation);
            stripSymbols.getTargetPlatform().set((Object)currentPlatform);
            stripSymbols.getToolChain().set((Object)toolChain);
        });
    }

    private TaskProvider<ExtractSymbols> extractSymbols(TaskProvider<? extends AbstractLinkTask> link, Names names, TaskContainer tasks, NativeToolChain toolChain, NativePlatform currentPlatform, Provider<RegularFile> symbolLocation) {
        return tasks.register(names.getTaskName("extractSymbols"), ExtractSymbols.class, extractSymbols -> {
            extractSymbols.getBinaryFile().set(link.flatMap(task -> task.getLinkedFile()));
            extractSymbols.getSymbolFile().set(symbolLocation);
            extractSymbols.getTargetPlatform().set((Object)currentPlatform);
            extractSymbols.getToolChain().set((Object)toolChain);
        });
    }

    static class LinkageSelectionRule
    implements AttributeDisambiguationRule<Linkage> {
        LinkageSelectionRule() {
        }

        public void execute(MultipleCandidatesDetails<Linkage> details) {
            if (details.getCandidateValues().contains(Linkage.SHARED)) {
                details.closestMatch((Object)Linkage.SHARED);
            }
        }
    }
}

