/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.processing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorResult;

public class AnnotationProcessingResult
implements Serializable {
    private final Map<String, Set<String>> generatedTypesByOrigin = new LinkedHashMap<String, Set<String>>();
    private final Set<String> aggregatedTypes = new HashSet<String>();
    private final Set<String> generatedTypesDependingOnAllOthers = new HashSet<String>();
    private final List<AnnotationProcessorResult> annotationProcessorResults = new ArrayList<AnnotationProcessorResult>();
    private String fullRebuildCause;

    public void addGeneratedType(String name, Set<String> originatingElements) {
        for (String originatingElement : originatingElements) {
            Set<String> derived = this.generatedTypesByOrigin.get(originatingElement);
            if (derived == null) {
                derived = new LinkedHashSet<String>();
                this.generatedTypesByOrigin.put(originatingElement, derived);
            }
            derived.add(name);
        }
    }

    public Map<String, Set<String>> getGeneratedTypesWithIsolatedOrigin() {
        return this.generatedTypesByOrigin;
    }

    public Set<String> getAggregatedTypes() {
        return this.aggregatedTypes;
    }

    public Set<String> getGeneratedAggregatingTypes() {
        return this.generatedTypesDependingOnAllOthers;
    }

    public void setFullRebuildCause(String fullRebuildCause) {
        this.fullRebuildCause = fullRebuildCause;
    }

    public String getFullRebuildCause() {
        return this.fullRebuildCause;
    }

    public List<AnnotationProcessorResult> getAnnotationProcessorResults() {
        return this.annotationProcessorResults;
    }
}

