/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedComponentResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentResultSerializer
implements Serializer<ResolvedGraphComponent> {
    private final ModuleVersionIdentifierSerializer idSerializer;
    private final ComponentSelectionReasonSerializer reasonSerializer;
    private final ComponentIdentifierSerializer componentIdSerializer;
    private final AttributeContainerSerializer attributeContainerSerializer;

    public ComponentResultSerializer(ImmutableModuleIdentifierFactory moduleIdentifierFactory, AttributeContainerSerializer attributeContainerSerializer) {
        this.idSerializer = new ModuleVersionIdentifierSerializer(moduleIdentifierFactory);
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.reasonSerializer = new ComponentSelectionReasonSerializer();
        this.componentIdSerializer = new ComponentIdentifierSerializer();
    }

    public ResolvedGraphComponent read(Decoder decoder) throws IOException {
        long resultId = decoder.readSmallLong();
        ModuleVersionIdentifier id = this.idSerializer.read(decoder);
        ComponentSelectionReason reason = this.reasonSerializer.read(decoder);
        ComponentIdentifier componentId = this.componentIdSerializer.read(decoder);
        String variantName = decoder.readString();
        ImmutableAttributes attributes = this.attributeContainerSerializer.read(decoder);
        String repositoryName = decoder.readNullableString();
        return new DetachedComponentResult(resultId, id, reason, componentId, variantName, (AttributeContainer)attributes, repositoryName);
    }

    public void write(Encoder encoder, ResolvedGraphComponent value) throws IOException {
        encoder.writeSmallLong(value.getResultId().longValue());
        this.idSerializer.write(encoder, value.getModuleVersion());
        this.reasonSerializer.write(encoder, value.getSelectionReason());
        this.componentIdSerializer.write(encoder, value.getComponentId());
        encoder.writeString((CharSequence)value.getVariantName().getDisplayName());
        this.attributeContainerSerializer.write(encoder, value.getVariantAttributes());
        encoder.writeNullableString((CharSequence)value.getRepositoryName());
    }
}

